/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * This file is available under and governed by the GNU General Public
 * License version 2 only, as published by the Free Software Foundation.
 * However, the following notice accompanied the original version of this
 * file:
 *
 * Written by Doug Lea with assistance from members of JCP JSR-166
 * Expert Group and released to the public domain, as explained at
 * http://creativecommons.org/publicdomain/zero/1.0/
 */


package java.util.concurrent.atomic;

import java.lang.invoke.VarHandle;

/**
 * An array of object references in which elements may be updated
 * atomically.  See the {@link java.lang.invoke.VarHandle VarHandle} specification for
 * descriptions of the properties of atomic accesses.
 * @since 1.5
 * @author Doug Lea
 * @param <E> The base class of elements held in this array
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AtomicReferenceArray<E> implements java.io.Serializable {

/**
 * Creates a new AtomicReferenceArray with the same length as, and
 * all elements copied from, the given array.
 *
 * @param array the array to copy elements from
 * @throws java.lang.NullPointerException if array is null
 */

public AtomicReferenceArray(E[] array) { throw new RuntimeException("Stub!"); }

/**
 * Creates a new AtomicReferenceArray of the given length, with all
 * elements initially null.
 *
 * @param length the length of the array
 */

public AtomicReferenceArray(int length) { throw new RuntimeException("Stub!"); }

/**
 * Atomically updates (with memory effects as specified by {@link java.lang.invoke.VarHandle#compareAndSet  }) the element at index {@code i} with
 * the results of applying the given function to the current and
 * given values, returning the updated value. The function should
 * be side-effect-free, since it may be re-applied when attempted
 * updates fail due to contention among threads.  The function is
 * applied with the current value of the element at index {@code i}
 * as its first argument, and the given update as the second
 * argument.
 *
 * @param i the index
 * @param x the update value
 * @param accumulatorFunction a side-effect-free function of two arguments
 * @return the updated value
 * @since 1.8
 */

public final E accumulateAndGet(int i, E x, java.util.function.BinaryOperator<E> accumulatorFunction) { throw new RuntimeException("Stub!"); }

/**
 * Atomically sets the element at index {@code i} to {@code newValue}
 * if the element's current value, referred to as the <em>witness
 * value</em>, {@code == expectedValue},
 * with memory effects as specified by
 * {@link java.lang.invoke.VarHandle#compareAndExchange VarHandle.compareAndExchange}.
 *
 * @param i the index
 * @param expectedValue the expected value
 * @param newValue the new value
 * @return the <em>witness value</em>, which will be the same as the
 * expected value if successful
 * @since 9
 */

public final E compareAndExchange(int i, E expectedValue, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Atomically sets the element at index {@code i} to {@code newValue}
 * if the element's current value, referred to as the <em>witness
 * value</em>, {@code == expectedValue},
 * with memory effects as specified by
 * {@link java.lang.invoke.VarHandle#compareAndExchangeAcquire VarHandle.compareAndExchangeAcquire}.
 *
 * @param i the index
 * @param expectedValue the expected value
 * @param newValue the new value
 * @return the <em>witness value</em>, which will be the same as the
 * expected value if successful
 * @since 9
 */

public final E compareAndExchangeAcquire(int i, E expectedValue, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Atomically sets the element at index {@code i} to {@code newValue}
 * if the element's current value, referred to as the <em>witness
 * value</em>, {@code == expectedValue},
 * with memory effects as specified by
 * {@link java.lang.invoke.VarHandle#compareAndExchangeRelease VarHandle.compareAndExchangeRelease}.
 *
 * @param i the index
 * @param expectedValue the expected value
 * @param newValue the new value
 * @return the <em>witness value</em>, which will be the same as the
 * expected value if successful
 * @since 9
 */

public final E compareAndExchangeRelease(int i, E expectedValue, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Atomically sets the element at index {@code i} to {@code newValue}
 * if the element's current value {@code == expectedValue},
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#compareAndSet VarHandle.compareAndSet}.
 *
 * @param i the index
 * @param expectedValue the expected value
 * @param newValue the new value
 * @return {@code true} if successful. False return indicates that
 * the actual value was not equal to the expected value.
 */

public final boolean compareAndSet(int i, E expectedValue, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Returns the current value of the element at index {@code i},
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#getVolatile VarHandle.getVolatile}.
 *
 * @param i the index
 * @return the current value
 */

public final E get(int i) { throw new RuntimeException("Stub!"); }

/**
 * Returns the current value of the element at index {@code i},
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#getAcquire VarHandle.getAcquire}.
 *
 * @param i the index
 * @return the value
 * @since 9
 */

public final E getAcquire(int i) { throw new RuntimeException("Stub!"); }

/**
 * Atomically updates (with memory effects as specified by {@link java.lang.invoke.VarHandle#compareAndSet  }) the element at index {@code i} with
 * the results of applying the given function to the current and
 * given values, returning the previous value. The function should
 * be side-effect-free, since it may be re-applied when attempted
 * updates fail due to contention among threads.  The function is
 * applied with the current value of the element at index {@code i}
 * as its first argument, and the given update as the second
 * argument.
 *
 * @param i the index
 * @param x the update value
 * @param accumulatorFunction a side-effect-free function of two arguments
 * @return the previous value
 * @since 1.8
 */

public final E getAndAccumulate(int i, E x, java.util.function.BinaryOperator<E> accumulatorFunction) { throw new RuntimeException("Stub!"); }

/**
 * Atomically sets the element at index {@code i} to {@code
 * newValue} and returns the old value,
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#getAndSet VarHandle.getAndSet}.
 *
 * @param i the index
 * @param newValue the new value
 * @return the previous value
 */

public final E getAndSet(int i, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Atomically updates (with memory effects as specified by {@link java.lang.invoke.VarHandle#compareAndSet  }) the element at index {@code i} with
 * the results of applying the given function, returning the
 * previous value. The function should be side-effect-free, since
 * it may be re-applied when attempted updates fail due to
 * contention among threads.
 *
 * @param i the index
 * @param updateFunction a side-effect-free function
 * @return the previous value
 * @since 1.8
 */

public final E getAndUpdate(int i, java.util.function.UnaryOperator<E> updateFunction) { throw new RuntimeException("Stub!"); }

/**
 * Returns the current value of the element at index {@code i},
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#getOpaque VarHandle.getOpaque}.
 *
 * @param i the index
 * @return the value
 * @since 9
 */

public final E getOpaque(int i) { throw new RuntimeException("Stub!"); }

/**
 * Returns the current value of the element at index {@code i},
 * with memory semantics of reading as if the variable was declared
 * non-{@code volatile}.
 *
 * @param i the index
 * @return the value
 * @since 9
 */

public final E getPlain(int i) { throw new RuntimeException("Stub!"); }

/**
 * Sets the element at index {@code i} to {@code newValue},
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#setRelease VarHandle.setRelease}.
 *
 * @param i the index
 * @param newValue the new value
 * @since 1.6
 */

public final void lazySet(int i, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Returns the length of the array.
 *
 * @return the length of the array
 */

public final int length() { throw new RuntimeException("Stub!"); }

/**
 * Sets the element at index {@code i} to {@code newValue},
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#setVolatile VarHandle.setVolatile}.
 *
 * @param i the index
 * @param newValue the new value
 */

public final void set(int i, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Sets the element at index {@code i} to {@code newValue},
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#setOpaque VarHandle.setOpaque}.
 *
 * @param i the index
 * @param newValue the new value
 * @since 9
 */

public final void setOpaque(int i, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Sets the element at index {@code i} to {@code newValue},
 * with memory semantics of setting as if the variable was
 * declared non-{@code volatile} and non-{@code final}.
 *
 * @param i the index
 * @param newValue the new value
 * @since 9
 */

public final void setPlain(int i, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Sets the element at index {@code i} to {@code newValue},
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#setRelease VarHandle.setRelease}.
 *
 * @param i the index
 * @param newValue the new value
 * @since 9
 */

public final void setRelease(int i, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Returns the String representation of the current values of array.
 * @return the String representation of the current values of array
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Atomically updates (with memory effects as specified by {@link java.lang.invoke.VarHandle#compareAndSet  }) the element at index {@code i} with
 * the results of applying the given function, returning the
 * updated value. The function should be side-effect-free, since it
 * may be re-applied when attempted updates fail due to contention
 * among threads.
 *
 * @param i the index
 * @param updateFunction a side-effect-free function
 * @return the updated value
 * @since 1.8
 */

public final E updateAndGet(int i, java.util.function.UnaryOperator<E> updateFunction) { throw new RuntimeException("Stub!"); }

/**
 * Possibly atomically sets the element at index {@code i} to
 * {@code newValue} if the element's current value {@code == expectedValue},
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#weakCompareAndSetPlain VarHandle.weakCompareAndSetPlain}.
 *
 * @deprecated This method has plain memory effects but the method
 * name implies volatile memory effects (see methods such as
 * {@link #compareAndExchange} and {@link #compareAndSet}).  To avoid
 * confusion over plain or volatile memory effects it is recommended that
 * the method {@link #weakCompareAndSetPlain} be used instead.
 *
 * @param i the index
 * @param expectedValue the expected value
 * @param newValue the new value
 * @return {@code true} if successful
 * @see #weakCompareAndSetPlain
 */

@Deprecated
public final boolean weakCompareAndSet(int i, E expectedValue, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Possibly atomically sets the element at index {@code i} to
 * {@code newValue} if the element's current value {@code == expectedValue},
 * with memory effects as specified by
 * {@link java.lang.invoke.VarHandle#weakCompareAndSetAcquire VarHandle.weakCompareAndSetAcquire}.
 *
 * @param i the index
 * @param expectedValue the expected value
 * @param newValue the new value
 * @return {@code true} if successful
 * @since 9
 */

public final boolean weakCompareAndSetAcquire(int i, E expectedValue, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Possibly atomically sets the element at index {@code i} to
 * {@code newValue} if the element's current value {@code == expectedValue},
 * with memory effects as specified by {@link java.lang.invoke.VarHandle#weakCompareAndSetPlain VarHandle.weakCompareAndSetPlain}.
 *
 * @param i the index
 * @param expectedValue the expected value
 * @param newValue the new value
 * @return {@code true} if successful
 * @since 9
 */

public final boolean weakCompareAndSetPlain(int i, E expectedValue, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Possibly atomically sets the element at index {@code i} to
 * {@code newValue} if the element's current value {@code == expectedValue},
 * with memory effects as specified by
 * {@link java.lang.invoke.VarHandle#weakCompareAndSetRelease VarHandle.weakCompareAndSetRelease}.
 *
 * @param i the index
 * @param expectedValue the expected value
 * @param newValue the new value
 * @return {@code true} if successful
 * @since 9
 */

public final boolean weakCompareAndSetRelease(int i, E expectedValue, E newValue) { throw new RuntimeException("Stub!"); }

/**
 * Possibly atomically sets the element at index {@code i} to
 * {@code newValue} if the element's current value {@code == expectedValue},
 * with memory effects as specified by
 * {@link java.lang.invoke.VarHandle#weakCompareAndSet VarHandle.weakCompareAndSet}.
 *
 * @param i the index
 * @param expectedValue the expected value
 * @param newValue the new value
 * @return {@code true} if successful
 * @since 9
 */

public final boolean weakCompareAndSetVolatile(int i, E expectedValue, E newValue) { throw new RuntimeException("Stub!"); }
}

