/*
 * Copyright (c) 1998, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.security.spec;


/**
 * This class specifies an RSA private key.
 *
 * @author Jan Luehe
 * @since 1.2
 *
 *
 * @see java.security.Key
 * @see java.security.KeyFactory
 * @see java.security.spec.KeySpec
 * @see java.security.spec.PKCS8EncodedKeySpec
 * @see java.security.spec.RSAPublicKeySpec
 * @see java.security.spec.RSAPrivateCrtKeySpec
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class RSAPrivateKeySpec implements java.security.spec.KeySpec {

/**
 * Creates a new RSAPrivateKeySpec.
 *
 * @param modulus the modulus
 * @param privateExponent the private exponent
 */

public RSAPrivateKeySpec(java.math.BigInteger modulus, java.math.BigInteger privateExponent) { throw new RuntimeException("Stub!"); }

/**
 * Creates a new RSAPrivateKeySpec with additional key parameters.
 *
 * @param modulus the modulus
 * @param privateExponent the private exponent
 * @param params the parameters associated with this key, may be null
 * @since 11
 */

public RSAPrivateKeySpec(java.math.BigInteger modulus, java.math.BigInteger privateExponent, java.security.spec.AlgorithmParameterSpec params) { throw new RuntimeException("Stub!"); }

/**
 * Returns the modulus.
 *
 * @return the modulus
 */

public java.math.BigInteger getModulus() { throw new RuntimeException("Stub!"); }

/**
 * Returns the parameters associated with this key, may be null if not
 * present.
 *
 * @return the parameters associated with this key
 * @since 11
 */

public java.security.spec.AlgorithmParameterSpec getParams() { throw new RuntimeException("Stub!"); }

/**
 * Returns the private exponent.
 *
 * @return the private exponent
 */

public java.math.BigInteger getPrivateExponent() { throw new RuntimeException("Stub!"); }
}

