/*
 * Copyright (c) 1995, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.lang;


/**
 * Thrown when an application tries to load in a class through its
 * string name using:
 * <ul>
 * <li>The {@code forName} method in class {@code Class}.
 * <li>The {@code findSystemClass} method in class
 *     {@code ClassLoader} .
 * <li>The {@code loadClass} method in class {@code ClassLoader}.
 * </ul>
 * <p>
 * but no definition for the class with the specified name could be found.
 *
 * @see     java.lang.Class#forName(java.lang.String)
 * @see     java.lang.ClassLoader#findSystemClass(java.lang.String)
 * @see     java.lang.ClassLoader#loadClass(java.lang.String, boolean)
 * @since   1.0
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ClassNotFoundException extends java.lang.ReflectiveOperationException {

/**
 * Constructs a {@code ClassNotFoundException} with no detail message.
 */

public ClassNotFoundException() { throw new RuntimeException("Stub!"); }

/**
 * Constructs a {@code ClassNotFoundException} with the
 * specified detail message.
 *
 * @param   s   the detail message.
 */

public ClassNotFoundException(java.lang.String s) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a {@code ClassNotFoundException} with the
 * specified detail message and optional exception that was
 * raised while loading the class.
 *
 * @param s the detail message
 * @param ex the exception that was raised while loading the class
 * @since 1.2
 */

public ClassNotFoundException(java.lang.String s, java.lang.Throwable ex) { throw new RuntimeException("Stub!"); }

/**
 * Returns the exception that was raised if an error occurred while
 * attempting to load the class. Otherwise, returns {@code null}.
 *
 * @apiNote
 * This method predates the general-purpose exception chaining facility.
 * The {@link java.lang.Throwable#getCause() Throwable.getCause()} method is now the preferred means of
 * obtaining this information.
 *
 * @return the {@code Exception} that was raised while loading a class
 * @since 1.2
 */

public java.lang.Throwable getException() { throw new RuntimeException("Stub!"); }
}

