/**
 * Provides for system input and output through data streams,
 * serialization and the file system.
 *
 * Unless otherwise noted, passing a null argument to a constructor or
 * method in any class or interface in this package will cause a
 * {@code NullPointerException} to be thrown.
 *
 * <h2>Object Serialization</h2>
 * <p><strong>Warning: Deserialization of untrusted data is inherently dangerous
 * and should be avoided. Untrusted data should be carefully validated according to the
 * "Serialization and Deserialization" section of the
 * <a href="https://docs.oracle.com/pls/topic/lookup?ctx=javase17&id=secure_coding_guidelines_javase">Secure Coding Guidelines for Java SE</a>.
 * </strong></p>
 * <ul>
 *   <li><a href="https://docs.oracle.com/en/java/javase/17/docs/specs/serialization/index.html">
 *       <cite>Java Object Serialization Specification</cite></a>
 *   <li><a href="https://docs.oracle.com/pls/topic/lookup?ctx=javase17&id=serialization_filter_guide">Serial Filtering</a> best practices</li>
 *   <li><a href="https://docs.oracle.com/pls/topic/lookup?ctx=javase17&id=serialver_tool_reference">The serialver tool</a></li>
 * </ul>
 *
 * @since 1.0
 */

package java.io;
