/*
 * Copyright (c) 1996, 2011, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.io;


/**
 * Abstract class for writing to character streams.  The only methods that a
 * subclass must implement are write(char[], int, int), flush(), and close().
 * Most subclasses, however, will override some of the methods defined here in
 * order to provide higher efficiency, additional functionality, or both.
 *
 * @see   java.io.BufferedWriter
 * @see   java.io.CharArrayWriter
 * @see   java.io.FilterWriter
 * @see   java.io.OutputStreamWriter
 * @see   java.io.FileWriter
 * @see   java.io.PipedWriter
 * @see   java.io.PrintWriter
 * @see   java.io.StringWriter
 * @see java.io.Reader
 *
 * @author      Mark Reinhold
 * @since       1.1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class Writer implements java.lang.Appendable, java.io.Closeable, java.io.Flushable {

/**
 * Creates a new character-stream writer whose critical sections will
 * synchronize on the writer itself.
 */

protected Writer() { throw new RuntimeException("Stub!"); }

/**
 * Creates a new character-stream writer whose critical sections will
 * synchronize on the given object.
 *
 * @param  lock
 *         Object to synchronize on
 */

protected Writer(java.lang.Object lock) { throw new RuntimeException("Stub!"); }

/**
 * Appends the specified character to this writer.
 *
 * <p> An invocation of this method of the form {@code out.append(c)}
 * behaves in exactly the same way as the invocation
 *
 * <pre>
 *     out.write(c) </pre>
 *
 * @param  c
 *         The 16-bit character to append
 *
 * @return  This writer
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 *
 * @since 1.5
 */

public java.io.Writer append(char c) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Appends the specified character sequence to this writer.
 *
 * <p> An invocation of this method of the form {@code out.append(csq)}
 * behaves in exactly the same way as the invocation
 *
 * <pre>
 *     out.write(csq.toString()) </pre>
 *
 * <p> Depending on the specification of {@code toString} for the
 * character sequence {@code csq}, the entire sequence may not be
 * appended. For instance, invoking the {@code toString} method of a
 * character buffer will return a subsequence whose content depends upon
 * the buffer's position and limit.
 *
 * @param  csq
 *         The character sequence to append.  If {@code csq} is
 *         {@code null}, then the four characters {@code "null"} are
 *         appended to this writer.
 *
 * @return  This writer
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 *
 * @since  1.5
 */

public java.io.Writer append(java.lang.CharSequence csq) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Appends a subsequence of the specified character sequence to this writer.
 * {@code Appendable}.
 *
 * <p> An invocation of this method of the form
 * {@code out.append(csq, start, end)} when {@code csq}
 * is not {@code null} behaves in exactly the
 * same way as the invocation
 *
 * <pre>{@code
 *     out.write(csq.subSequence(start, end).toString())
 * }</pre>
 *
 * @param  csq
 *         The character sequence from which a subsequence will be
 *         appended.  If {@code csq} is {@code null}, then characters
 *         will be appended as if {@code csq} contained the four
 *         characters {@code "null"}.
 *
 * @param  start
 *         The index of the first character in the subsequence
 *
 * @param  end
 *         The index of the character following the last character in the
 *         subsequence
 *
 * @return  This writer
 *
 * @throws  java.lang.IndexOutOfBoundsException
 *          If {@code start} or {@code end} are negative, {@code start}
 *          is greater than {@code end}, or {@code end} is greater than
 *          {@code csq.length()}
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 *
 * @since  1.5
 */

public java.io.Writer append(java.lang.CharSequence csq, int start, int end) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Closes the stream, flushing it first. Once the stream has been closed,
 * further write() or flush() invocations will cause an IOException to be
 * thrown. Closing a previously closed stream has no effect.
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 */

public abstract void close() throws java.io.IOException;

/**
 * Flushes the stream.  If the stream has saved any characters from the
 * various write() methods in a buffer, write them immediately to their
 * intended destination.  Then, if that destination is another character or
 * byte stream, flush it.  Thus one flush() invocation will flush all the
 * buffers in a chain of Writers and OutputStreams.
 *
 * <p> If the intended destination of this stream is an abstraction provided
 * by the underlying operating system, for example a file, then flushing the
 * stream guarantees only that bytes previously written to the stream are
 * passed to the operating system for writing; it does not guarantee that
 * they are actually written to a physical device such as a disk drive.
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 */

public abstract void flush() throws java.io.IOException;

/**
 * Returns a new {@code Writer} which discards all characters.  The
 * returned stream is initially open.  The stream is closed by calling
 * the {@code close()} method.  Subsequent calls to {@code close()} have
 * no effect.
 *
 * <p> While the stream is open, the {@code append(char)}, {@code
 * append(CharSequence)}, {@code append(CharSequence, int, int)},
 * {@code flush()}, {@code write(int)}, {@code write(char[])}, and
 * {@code write(char[], int, int)} methods do nothing. After the stream
 * has been closed, these methods all throw {@code IOException}.
 *
 * <p> The {@link #lock object} used to synchronize operations on the
 * returned {@code Writer} is not specified.
 *
 * @return a {@code Writer} which discards all characters
 *
 * @since 11
 */

public static java.io.Writer nullWriter() { throw new RuntimeException("Stub!"); }

/**
 * Writes an array of characters.
 *
 * @param  cbuf
 *         Array of characters to be written
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 */

public void write(char[] cbuf) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Writes a portion of an array of characters.
 *
 * @param  cbuf
 *         Array of characters
 *
 * @param  off
 *         Offset from which to start writing characters
 *
 * @param  len
 *         Number of characters to write
 *
 * @throws  java.lang.IndexOutOfBoundsException
 *          Implementations should throw this exception
 *          if {@code off} is negative, or {@code len} is negative,
 *          or {@code off + len} is negative or greater than the length
 *          of the given array
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 */

public abstract void write(char[] cbuf, int off, int len) throws java.io.IOException;

/**
 * Writes a single character.  The character to be written is contained in
 * the 16 low-order bits of the given integer value; the 16 high-order bits
 * are ignored.
 *
 * <p> Subclasses that intend to support efficient single-character output
 * should override this method.
 *
 * @param  c
 *         int specifying a character to be written
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 */

public void write(int c) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Writes a string.
 *
 * @param  str
 *         String to be written
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 */

public void write(java.lang.String str) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Writes a portion of a string.
 *
 * @implSpec
 * The implementation in this class throws an
 * {@code IndexOutOfBoundsException} for the indicated conditions;
 * overriding methods may choose to do otherwise.
 *
 * @param  str
 *         A String
 *
 * @param  off
 *         Offset from which to start writing characters
 *
 * @param  len
 *         Number of characters to write
 *
 * @throws  java.lang.IndexOutOfBoundsException
 *          Implementations should throw this exception
 *          if {@code off} is negative, or {@code len} is negative,
 *          or {@code off + len} is negative or greater than the length
 *          of the given string
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 */

public void write(java.lang.String str, int off, int len) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * The object used to synchronize operations on this stream.  For
 * efficiency, a character-stream object may use an object other than
 * itself to protect critical sections.  A subclass should therefore use
 * the object in this field rather than {@code this} or a synchronized
 * method.
 */

protected java.lang.Object lock;
}

