/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.webkit;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class WebSettings {

public WebSettings() { throw new RuntimeException("Stub!"); }

@Deprecated
public abstract boolean enableSmoothTransition();

public abstract boolean getAllowContentAccess();

public abstract boolean getAllowFileAccess();

public abstract boolean getAllowFileAccessFromFileURLs();

public abstract boolean getAllowUniversalAccessFromFileURLs();

public abstract boolean getBlockNetworkImage();

public abstract boolean getBlockNetworkLoads();

public abstract boolean getBuiltInZoomControls();

public abstract int getCacheMode();

public abstract java.lang.String getCursiveFontFamily();

@Deprecated
public abstract boolean getDatabaseEnabled();

@Deprecated
public abstract java.lang.String getDatabasePath();

public abstract int getDefaultFixedFontSize();

public abstract int getDefaultFontSize();

public abstract java.lang.String getDefaultTextEncodingName();

public static java.lang.String getDefaultUserAgent(android.content.Context context) { throw new RuntimeException("Stub!"); }

@Deprecated
public abstract android.webkit.WebSettings.ZoomDensity getDefaultZoom();

public abstract int getDisabledActionModeMenuItems();

public abstract boolean getDisplayZoomControls();

public abstract boolean getDomStorageEnabled();

public abstract java.lang.String getFantasyFontFamily();

public abstract java.lang.String getFixedFontFamily();

@Deprecated
public int getForceDark() { throw new RuntimeException("Stub!"); }

public abstract boolean getJavaScriptCanOpenWindowsAutomatically();

public abstract boolean getJavaScriptEnabled();

public abstract android.webkit.WebSettings.LayoutAlgorithm getLayoutAlgorithm();

@Deprecated
public abstract boolean getLightTouchEnabled();

public abstract boolean getLoadWithOverviewMode();

public abstract boolean getLoadsImagesAutomatically();

public abstract boolean getMediaPlaybackRequiresUserGesture();

public abstract int getMinimumFontSize();

public abstract int getMinimumLogicalFontSize();

public abstract int getMixedContentMode();

public abstract boolean getOffscreenPreRaster();

@Deprecated
public abstract android.webkit.WebSettings.PluginState getPluginState();

public abstract boolean getSafeBrowsingEnabled();

public abstract java.lang.String getSansSerifFontFamily();

@Deprecated
public abstract boolean getSaveFormData();

@Deprecated
public abstract boolean getSavePassword();

public abstract java.lang.String getSerifFontFamily();

public abstract java.lang.String getStandardFontFamily();

@Deprecated
public synchronized android.webkit.WebSettings.TextSize getTextSize() { throw new RuntimeException("Stub!"); }

public abstract int getTextZoom();

public abstract boolean getUseWideViewPort();

public abstract java.lang.String getUserAgentString();

public boolean isAlgorithmicDarkeningAllowed() { throw new RuntimeException("Stub!"); }

public void setAlgorithmicDarkeningAllowed(boolean allow) { throw new RuntimeException("Stub!"); }

public abstract void setAllowContentAccess(boolean allow);

public abstract void setAllowFileAccess(boolean allow);

@Deprecated
public abstract void setAllowFileAccessFromFileURLs(boolean flag);

@Deprecated
public abstract void setAllowUniversalAccessFromFileURLs(boolean flag);

public abstract void setBlockNetworkImage(boolean flag);

public abstract void setBlockNetworkLoads(boolean flag);

public abstract void setBuiltInZoomControls(boolean enabled);

public abstract void setCacheMode(int mode);

public abstract void setCursiveFontFamily(java.lang.String font);

@Deprecated
public abstract void setDatabaseEnabled(boolean flag);

@Deprecated
public abstract void setDatabasePath(java.lang.String databasePath);

public abstract void setDefaultFixedFontSize(int size);

public abstract void setDefaultFontSize(int size);

public abstract void setDefaultTextEncodingName(java.lang.String encoding);

@Deprecated
public abstract void setDefaultZoom(android.webkit.WebSettings.ZoomDensity zoom);

public abstract void setDisabledActionModeMenuItems(int menuItems);

public abstract void setDisplayZoomControls(boolean enabled);

public abstract void setDomStorageEnabled(boolean flag);

@Deprecated
public abstract void setEnableSmoothTransition(boolean enable);

public abstract void setFantasyFontFamily(java.lang.String font);

public abstract void setFixedFontFamily(java.lang.String font);

@Deprecated
public void setForceDark(int forceDark) { throw new RuntimeException("Stub!"); }

@Deprecated
public abstract void setGeolocationDatabasePath(java.lang.String databasePath);

public abstract void setGeolocationEnabled(boolean flag);

public abstract void setJavaScriptCanOpenWindowsAutomatically(boolean flag);

public abstract void setJavaScriptEnabled(boolean flag);

public abstract void setLayoutAlgorithm(android.webkit.WebSettings.LayoutAlgorithm l);

@Deprecated
public abstract void setLightTouchEnabled(boolean enabled);

public abstract void setLoadWithOverviewMode(boolean overview);

public abstract void setLoadsImagesAutomatically(boolean flag);

public abstract void setMediaPlaybackRequiresUserGesture(boolean require);

public abstract void setMinimumFontSize(int size);

public abstract void setMinimumLogicalFontSize(int size);

public abstract void setMixedContentMode(int mode);

public abstract void setNeedInitialFocus(boolean flag);

public abstract void setOffscreenPreRaster(boolean enabled);

@Deprecated
public abstract void setPluginState(android.webkit.WebSettings.PluginState state);

@Deprecated
public abstract void setRenderPriority(android.webkit.WebSettings.RenderPriority priority);

public abstract void setSafeBrowsingEnabled(boolean enabled);

public abstract void setSansSerifFontFamily(java.lang.String font);

@Deprecated
public abstract void setSaveFormData(boolean save);

@Deprecated
public abstract void setSavePassword(boolean save);

public abstract void setSerifFontFamily(java.lang.String font);

public abstract void setStandardFontFamily(java.lang.String font);

public abstract void setSupportMultipleWindows(boolean support);

public abstract void setSupportZoom(boolean support);

@Deprecated
public synchronized void setTextSize(android.webkit.WebSettings.TextSize t) { throw new RuntimeException("Stub!"); }

public abstract void setTextZoom(int textZoom);

public abstract void setUseWideViewPort(boolean use);

public abstract void setUserAgentString(@android.annotation.Nullable java.lang.String ua);

public abstract boolean supportMultipleWindows();

public abstract boolean supportZoom();

@Deprecated public static final int FORCE_DARK_AUTO = 1; // 0x1

@Deprecated public static final int FORCE_DARK_OFF = 0; // 0x0

@Deprecated public static final int FORCE_DARK_ON = 2; // 0x2

public static final int LOAD_CACHE_ELSE_NETWORK = 1; // 0x1

public static final int LOAD_CACHE_ONLY = 3; // 0x3

public static final int LOAD_DEFAULT = -1; // 0xffffffff

@Deprecated public static final int LOAD_NORMAL = 0; // 0x0

public static final int LOAD_NO_CACHE = 2; // 0x2

public static final int MENU_ITEM_NONE = 0; // 0x0

public static final int MENU_ITEM_PROCESS_TEXT = 4; // 0x4

public static final int MENU_ITEM_SHARE = 1; // 0x1

public static final int MENU_ITEM_WEB_SEARCH = 2; // 0x2

public static final int MIXED_CONTENT_ALWAYS_ALLOW = 0; // 0x0

public static final int MIXED_CONTENT_COMPATIBILITY_MODE = 2; // 0x2

public static final int MIXED_CONTENT_NEVER_ALLOW = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum LayoutAlgorithm {
@Deprecated
NARROW_COLUMNS,
NORMAL,
@Deprecated
SINGLE_COLUMN,
TEXT_AUTOSIZING;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum PluginState {
OFF,
ON,
ON_DEMAND;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum RenderPriority {
HIGH,
LOW,
NORMAL;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public enum TextSize {
@Deprecated
LARGER,
@Deprecated
LARGEST,
@Deprecated
NORMAL,
@Deprecated
SMALLER,
@Deprecated
SMALLEST;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum ZoomDensity {
CLOSE,
FAR,
MEDIUM;
}

}

