/*
 * Copyright (C) 2007-2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


package android.view.inputmethod;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface InputMethodSession {

public void appPrivateCommand(java.lang.String action, android.os.Bundle data);

public void dispatchGenericMotionEvent(int seq, android.view.MotionEvent event, android.view.inputmethod.InputMethodSession.EventCallback callback);

public void dispatchKeyEvent(int seq, android.view.KeyEvent event, android.view.inputmethod.InputMethodSession.EventCallback callback);

public void dispatchTrackballEvent(int seq, android.view.MotionEvent event, android.view.inputmethod.InputMethodSession.EventCallback callback);

public void displayCompletions(android.view.inputmethod.CompletionInfo[] completions);

public void finishInput();

@Deprecated
public void toggleSoftInput(int showFlags, int hideFlags);

public void updateCursor(android.graphics.Rect newCursor);

public void updateCursorAnchorInfo(android.view.inputmethod.CursorAnchorInfo cursorAnchorInfo);

public void updateExtractedText(int token, android.view.inputmethod.ExtractedText text);

public void updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd);

public void viewClicked(boolean focusChanged);
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface EventCallback {

public void finishedEvent(int seq, boolean handled);
}

}

