/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface MenuItem {

public boolean collapseActionView();

public boolean expandActionView();

@android.annotation.Nullable
public android.view.ActionProvider getActionProvider();

@android.annotation.Nullable
public android.view.View getActionView();

public default int getAlphabeticModifiers() { throw new RuntimeException("Stub!"); }

public char getAlphabeticShortcut();

@android.annotation.Nullable
public default java.lang.CharSequence getContentDescription() { throw new RuntimeException("Stub!"); }

public int getGroupId();

@android.annotation.Nullable
public android.graphics.drawable.Drawable getIcon();

@android.annotation.Nullable
public default android.graphics.BlendMode getIconTintBlendMode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public default android.content.res.ColorStateList getIconTintList() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public default android.graphics.PorterDuff.Mode getIconTintMode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.Intent getIntent();

public int getItemId();

@android.annotation.Nullable
public android.view.ContextMenu.ContextMenuInfo getMenuInfo();

public default int getNumericModifiers() { throw new RuntimeException("Stub!"); }

public char getNumericShortcut();

public int getOrder();

@android.annotation.Nullable
public android.view.SubMenu getSubMenu();

@android.annotation.Nullable
public java.lang.CharSequence getTitle();

@android.annotation.Nullable
public java.lang.CharSequence getTitleCondensed();

@android.annotation.Nullable
public default java.lang.CharSequence getTooltipText() { throw new RuntimeException("Stub!"); }

public boolean hasSubMenu();

public boolean isActionViewExpanded();

public boolean isCheckable();

public boolean isChecked();

public boolean isEnabled();

public boolean isVisible();

@android.annotation.NonNull
public android.view.MenuItem setActionProvider(@android.annotation.Nullable android.view.ActionProvider actionProvider);

@android.annotation.NonNull
public android.view.MenuItem setActionView(@android.annotation.Nullable android.view.View view);

@android.annotation.NonNull
public android.view.MenuItem setActionView(int resId);

@android.annotation.NonNull
public android.view.MenuItem setAlphabeticShortcut(char alphaChar);

@android.annotation.NonNull
public default android.view.MenuItem setAlphabeticShortcut(char alphaChar, int alphaModifiers) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.MenuItem setCheckable(boolean checkable);

@android.annotation.NonNull
public android.view.MenuItem setChecked(boolean checked);

@android.annotation.NonNull
public default android.view.MenuItem setContentDescription(@android.annotation.Nullable java.lang.CharSequence contentDescription) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.MenuItem setEnabled(boolean enabled);

@android.annotation.NonNull
public android.view.MenuItem setIcon(@android.annotation.Nullable android.graphics.drawable.Drawable icon);

@android.annotation.NonNull
public android.view.MenuItem setIcon(int iconRes);

@android.annotation.NonNull
public default android.view.MenuItem setIconTintBlendMode(@android.annotation.Nullable android.graphics.BlendMode blendMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public default android.view.MenuItem setIconTintList(@android.annotation.Nullable android.content.res.ColorStateList tint) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public default android.view.MenuItem setIconTintMode(@android.annotation.Nullable android.graphics.PorterDuff.Mode tintMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.MenuItem setIntent(@android.annotation.Nullable android.content.Intent intent);

@android.annotation.NonNull
public android.view.MenuItem setNumericShortcut(char numericChar);

@android.annotation.NonNull
public default android.view.MenuItem setNumericShortcut(char numericChar, int numericModifiers) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.MenuItem setOnActionExpandListener(@android.annotation.Nullable android.view.MenuItem.OnActionExpandListener listener);

@android.annotation.NonNull
public android.view.MenuItem setOnMenuItemClickListener(@android.annotation.Nullable android.view.MenuItem.OnMenuItemClickListener menuItemClickListener);

@android.annotation.NonNull
public android.view.MenuItem setShortcut(char numericChar, char alphaChar);

@android.annotation.NonNull
public default android.view.MenuItem setShortcut(char numericChar, char alphaChar, int numericModifiers, int alphaModifiers) { throw new RuntimeException("Stub!"); }

public void setShowAsAction(int actionEnum);

@android.annotation.NonNull
public android.view.MenuItem setShowAsActionFlags(int actionEnum);

@android.annotation.NonNull
public android.view.MenuItem setTitle(int title);

@android.annotation.NonNull
public android.view.MenuItem setTitle(@android.annotation.Nullable java.lang.CharSequence title);

@android.annotation.NonNull
public android.view.MenuItem setTitleCondensed(@android.annotation.Nullable java.lang.CharSequence title);

@android.annotation.NonNull
public default android.view.MenuItem setTooltipText(@android.annotation.Nullable java.lang.CharSequence tooltipText) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.MenuItem setVisible(boolean visible);

public static final int SHOW_AS_ACTION_ALWAYS = 2; // 0x2

public static final int SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW = 8; // 0x8

public static final int SHOW_AS_ACTION_IF_ROOM = 1; // 0x1

public static final int SHOW_AS_ACTION_NEVER = 0; // 0x0

public static final int SHOW_AS_ACTION_WITH_TEXT = 4; // 0x4
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnActionExpandListener {

public boolean onMenuItemActionCollapse(@android.annotation.NonNull android.view.MenuItem item);

public boolean onMenuItemActionExpand(@android.annotation.NonNull android.view.MenuItem item);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnMenuItemClickListener {

public boolean onMenuItemClick(@android.annotation.NonNull android.view.MenuItem item);
}

}

