/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.uwb;


/**
 * Represents the capabilities of Ultra-Wideband (UWB) ranging technology.
 *
 * <p>This class encapsulates various UWB-related features, including support for specific
 * measurement types (e.g., distance, azimuth, elevation), ranging configurations, and
 * operational parameters like update rates and channel availability.</p>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UwbRangingCapabilities implements android.os.Parcelable {

UwbRangingCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Gets the minimum supported ranging interval.
 *
 * @return the minimum ranging interval.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Duration getMinimumRangingInterval() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of supported UWB channels.
 *
 * @return a list of supported channel numbers.
 
 * This value cannot be {@code null}.

 * Value is {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_5}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_6}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_8}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_9}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_10}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_12}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_13}, or {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_14}
 */

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getSupportedChannels() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of supported configuration IDs.
 *
 * @return a list of supported configuration IDs.
 
 * This value cannot be {@code null}.

 * Value is {@link android.ranging.uwb.UwbRangingParams#CONFIG_UNICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_MULTICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_UNICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_MULTICAST_DS_TWR}, {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_INDIVIDUAL_MULTICAST_DS_TWR}, or {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_UNICAST_DS_TWR_VERY_FAST}
 */

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getSupportedConfigIds() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of supported notification configurations.
 *
 * @return a list of supported notification configuration type.
 
 * This value cannot be {@code null}.

 * Value is {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_DISABLE}, {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_ENABLE}, {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_PROXIMITY_LEVEL}, or {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_PROXIMITY_EDGE}
 */

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getSupportedNotificationConfigurations() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of supported preamble indexes.
 *
 * @return a list of supported preamble indexes.
 *
 
 * This value cannot be {@code null}.

 * Value is {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_9}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_10}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_11}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_12}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_25}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_26}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_27}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_28}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_29}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_30}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_31}, or {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_32}
 */

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getSupportedPreambleIndexes() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of supported ranging update rates.
 *
 * @return a list of supported update rates.
 
 * This value cannot be {@code null}.

 * Value is {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_NORMAL}, {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_INFREQUENT}, or {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_FREQUENT}
 */

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getSupportedRangingUpdateRates() { throw new RuntimeException("Stub!"); }

/**
 * Gets the list of supported slot durations in microseconds.
 *
 * @return a list of supported slot durations.
 
 * This value cannot be {@code null}.

 * Value is {@link android.ranging.uwb.UwbRangingParams#DURATION_1_MS}, or {@link android.ranging.uwb.UwbRangingParams#DURATION_2_MS}
 */

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getSupportedSlotDurations() { throw new RuntimeException("Stub!"); }

/**
 * Checks if the device hardware supports azimuthal angle measurement.
 *
 * @return {@code true} if azimuthal angle measurement is supported; {@code false} otherwise.
 */

public boolean isAzimuthalAngleSupported() { throw new RuntimeException("Stub!"); }

/**
 * Checks if background ranging is supported.
 *
 * @return {@code true} if background ranging is supported; {@code false} otherwise.
 */

public boolean isBackgroundRangingSupported() { throw new RuntimeException("Stub!"); }

/**
 * Checks if the device supports distance measurement.
 *
 * @return {@code true} if distance measurement is supported; {@code false} otherwise.
 */

public boolean isDistanceMeasurementSupported() { throw new RuntimeException("Stub!"); }

/**
 * Checks if the device hardware supports elevation angle measurement.
 *
 * @return {@code true} if elevation angle measurement is supported; {@code false} otherwise.
 */

public boolean isElevationAngleSupported() { throw new RuntimeException("Stub!"); }

/**
 * Checks if the ranging interval can be reconfigured.
 *
 * @return {@code true} if the interval is configurable; {@code false} otherwise.
 */

public boolean isRangingIntervalReconfigurationSupported() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.uwb.UwbRangingCapabilities> CREATOR;
static { CREATOR = null; }
}

