/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.uwb;


/**
 * A class representing a UWB address
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UwbAddress implements android.os.Parcelable {

UwbAddress() { throw new RuntimeException("Stub!"); }

/**
 * Generates a new random 2 bytes {@link android.ranging.uwb.UwbAddress UwbAddress}.
 *
 * @return a new randomly generated {@link android.ranging.uwb.UwbAddress UwbAddress}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.ranging.uwb.UwbAddress createRandomShortAddress() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param obj This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Create a {@link android.uwb.UwbAddress} from a byte array.
 *
 * <p>If the provided array is {@link #SHORT_ADDRESS_BYTE_LENGTH} bytes, a short address is
 * created. If the provided array is {@link #EXTENDED_ADDRESS_BYTE_LENGTH} bytes, then an
 * extended address is created.
 *
 * @param address a byte array to convert to a {@link android.uwb.UwbAddress}
 * This value cannot be {@code null}.
 * @return a {@link android.uwb.UwbAddress} created from the input byte array
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException when the length is not one of
 *       {@link #SHORT_ADDRESS_BYTE_LENGTH} or {@link #EXTENDED_ADDRESS_BYTE_LENGTH} bytes
 */

@android.annotation.NonNull
public static android.ranging.uwb.UwbAddress fromBytes(@android.annotation.NonNull byte[] address) { throw new RuntimeException("Stub!"); }

/**
 * Get the address as a byte array
 *
 * @return the byte representation of this {@link android.uwb.UwbAddress}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getAddressBytes() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.uwb.UwbAddress> CREATOR;
static { CREATOR = null; }

public static final int EXTENDED_ADDRESS_BYTE_LENGTH = 8; // 0x8

public static final int SHORT_ADDRESS_BYTE_LENGTH = 2; // 0x2
}

