/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.raw;

import android.ranging.RangingDevice;
import android.ranging.ble.cs.BleCsRangingParams;
import android.ranging.ble.rssi.BleRssiRangingParams;
import android.ranging.uwb.UwbRangingCapabilities;
import android.ranging.uwb.UwbRangingParams;
import android.ranging.wifi.rtt.RttRangingCapabilities;
import android.ranging.wifi.rtt.RttRangingParams;

/**
 * Represents a device participating in ranging operations.
 * This class supports multiple ranging technologies, including UWB, BLE CS, BLE RSSI and Wi-Fi
 * NAN-RTT. The configuration for each technology is provided through corresponding parameter
 * objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RawRangingDevice implements android.os.Parcelable {

RawRangingDevice() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the BLE rssi ranging parameters, if applicable.
 *
 * @return the {@link android.ranging.ble.rssi.BleRssiRangingParams BleRssiRangingParams}, or {@code null} if not set.
 */

@android.annotation.Nullable
public android.ranging.ble.rssi.BleRssiRangingParams getBleRssiRangingParams() { throw new RuntimeException("Stub!"); }

/**
 * Returns the CS ranging parameters, if applicable.
 *
 * @return the {@link android.ranging.ble.cs.BleCsRangingParams BleCsRangingParams}, or {@code null} if not set.
 */

@android.annotation.Nullable
public android.ranging.ble.cs.BleCsRangingParams getCsRangingParams() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.ranging.RangingDevice RangingDevice} associated with this instance.
 *
 * @return the ranging device.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.RangingDevice getRangingDevice() { throw new RuntimeException("Stub!"); }

/**
 * Returns the RTT ranging parameters, if applicable.
 *
 * @return the {@link android.ranging.wifi.rtt.RttRangingParams RttRangingParams}, or {@code null} if not set.
 */

@android.annotation.Nullable
public android.ranging.wifi.rtt.RttRangingParams getRttRangingParams() { throw new RuntimeException("Stub!"); }

/**
 * Returns the UWB ranging parameters, if applicable.
 *
 * @return the {@link android.ranging.uwb.UwbRangingParams UwbRangingParams}, or {@code null} if not set.
 */

@android.annotation.Nullable
public android.ranging.uwb.UwbRangingParams getUwbRangingParams() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.raw.RawRangingDevice> CREATOR;
static { CREATOR = null; }

/**
 * Frequent ranging interval.
 * <ul>
 *     <li> UWB - 96 milliseconds for config id
 *     {@link android.ranging.uwb.UwbRangingParams#CONFIG_PROVISIONED_UNICAST_DS_TWR_VERY_FAST UwbRangingParams.CONFIG_PROVISIONED_UNICAST_DS_TWR_VERY_FAST}, 120 milliseconds
 *     otherwise. See {@link android.ranging.uwb.UwbRangingCapabilities#getSupportedRangingUpdateRates() UwbRangingCapabilities.getSupportedRangingUpdateRates()} to verify
 *     Frequent update rate is supported. </li>
 *     <li> BLE RSSI - 500 milliseconds. </li>
 *     <li> BLE CS - 100 milliseconds. </li>
 *     <li> WiFi Rtt - 128 milliseconds if
 *     {@link android.ranging.wifi.rtt.RttRangingCapabilities#hasPeriodicRangingHardwareFeature() RttRangingCapabilities.hasPeriodicRangingHardwareFeature()} is true, 256
 *     milliseconds otherwise. </li>
 * </ul>
 */

public static final int UPDATE_RATE_FREQUENT = 3; // 0x3

/**
 * Infrequent ranging interval.
 * <ul>
 *     <li> UWB - 600 milliseconds. </li>
 *     <li> BLE RSSI - 3 seconds. </li>
 *     <li> BLE CS - 5 seconds. </li>
 *     <li> WiFi Rtt - 8192 milliseconds otherwise. </li>
 * </ul>
 */

public static final int UPDATE_RATE_INFREQUENT = 2; // 0x2

/**
 * Normal ranging interval (Default).
 * <ul>
 *     <li> UWB - 200 milliseconds for config ids {@link android.ranging.uwb.UwbRangingParams#getConfigId() UwbRangingParams.getConfigId()} with
 *     multicast ranging, 240 milliseconds for unicast. </li>
 *     <li> BLE RSSI - 1 second. </li>
 *     <li> BLE CS - 200 ms. </li>
 *     <li> WiFi Rtt - 256 milliseconds if
 *     {@link android.ranging.wifi.rtt.RttRangingCapabilities#hasPeriodicRangingHardwareFeature() RttRangingCapabilities.hasPeriodicRangingHardwareFeature()} is true, 512
 *     milliseconds otherwise. </li>
 * </ul>
 */

public static final int UPDATE_RATE_NORMAL = 1; // 0x1
/**
 * Builder class for creating instances of {@link android.ranging.raw.RawRangingDevice RawRangingDevice}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns a new {@link android.ranging.raw.RawRangingDevice RawRangingDevice} instance.
 *
 * @return a new {@link android.ranging.raw.RawRangingDevice RawRangingDevice} configured with the specified parameters.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawRangingDevice build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the BLE rssi ranging parameters.
 *
 * @param params the {@link android.ranging.ble.cs.BleCsRangingParams BleCsRangingParams} to be set.
 * This value cannot be {@code null}.
 * @return this {@link android.ranging.raw.RawRangingDevice.Builder Builder} instance for chaining calls.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawRangingDevice.Builder setBleRssiRangingParams(@android.annotation.NonNull android.ranging.ble.rssi.BleRssiRangingParams params) { throw new RuntimeException("Stub!"); }

/**
 * Sets the BLE channel sounding ranging parameters.
 *
 * @param params the {@link android.ranging.ble.cs.BleCsRangingParams BleCsRangingParams} to be set.
 * This value cannot be {@code null}.
 * @return this {@link android.ranging.raw.RawRangingDevice.Builder Builder} instance for chaining calls.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawRangingDevice.Builder setCsRangingParams(@android.annotation.NonNull android.ranging.ble.cs.BleCsRangingParams params) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ranging device.
 *
 * @param rangingDevice the {@link android.ranging.RangingDevice RangingDevice} to be set.
 * This value cannot be {@code null}.
 * @return this {@link android.ranging.raw.RawRangingDevice.Builder Builder} instance for chaining calls.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawRangingDevice.Builder setRangingDevice(@android.annotation.NonNull android.ranging.RangingDevice rangingDevice) { throw new RuntimeException("Stub!"); }

/**
 * Sets the WiFi NAN-RTT ranging parameters.
 *
 * @param params the {@link android.ranging.wifi.rtt.RttRangingParams RttRangingParams} to be set.
 * This value cannot be {@code null}.
 * @return this {@link android.ranging.raw.RawRangingDevice.Builder Builder} instance for chaining calls.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawRangingDevice.Builder setRttRangingParams(@android.annotation.NonNull android.ranging.wifi.rtt.RttRangingParams params) { throw new RuntimeException("Stub!"); }

/**
 * Sets the UWB ranging parameters.
 *
 * @param params the {@link android.ranging.uwb.UwbRangingParams UwbRangingParams} to be set.
 * This value cannot be {@code null}.
 * @return this {@link android.ranging.raw.RawRangingDevice.Builder Builder} instance for chaining calls.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawRangingDevice.Builder setUwbRangingParams(@android.annotation.NonNull android.ranging.uwb.UwbRangingParams params) { throw new RuntimeException("Stub!"); }
}

}

