/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.raw;


/**
 * Represents the configuration for initiating a raw ranging session.
 * This class encapsulates a list of {@link android.ranging.raw.RawRangingDevice RawRangingDevice} objects that
 * participate in the
 * session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RawInitiatorRangingConfig extends android.ranging.RangingConfig implements android.os.Parcelable {

RawInitiatorRangingConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of {@link android.ranging.raw.RawRangingDevice RawRangingDevice} objects involved in this
 * session.
 *
 * @return a list of ranging devices.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.ranging.raw.RawRangingDevice> getRawRangingDevices() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.raw.RawInitiatorRangingConfig> CREATOR;
static { CREATOR = null; }
/**
 * Builder class for constructing instances of {@link android.ranging.raw.RawInitiatorRangingConfig RawInitiatorRangingConfig}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Adds a {@link android.ranging.raw.RawRangingDevice RawRangingDevice} to the list of devices for this
 * session.
 *
 * @param rangingDevice the device to be added.
 * This value cannot be {@code null}.
 * @return this {@link android.ranging.raw.RawInitiatorRangingConfig.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawInitiatorRangingConfig.Builder addRawRangingDevice(@android.annotation.NonNull android.ranging.raw.RawRangingDevice rangingDevice) { throw new RuntimeException("Stub!"); }

/**
 * Adds a list of {@link android.ranging.raw.RawRangingDevice} to the list of devices for
 * this session.
 *
 * @param rangingDevices the list of devices to be added.
 * This value cannot be {@code null}.
 * @return this {@link android.ranging.raw.RawInitiatorRangingConfig.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawInitiatorRangingConfig.Builder addRawRangingDevices(@android.annotation.NonNull java.util.List<android.ranging.raw.RawRangingDevice> rangingDevices) { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns a new {@link android.ranging.raw.RawInitiatorRangingConfig RawInitiatorRangingConfig} instance.
 *
 * @return a configured instance of {@link android.ranging.raw.RawInitiatorRangingConfig RawInitiatorRangingConfig}.
 * This value cannot be {@code null}.
 * @throws  java.lang.IllegalArgumentException if no {@link android.ranging.raw.RawRangingDevice RawRangingDevice} is configured.
 */

@android.annotation.NonNull
public android.ranging.raw.RawInitiatorRangingConfig build() { throw new RuntimeException("Stub!"); }
}

}

