/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.ble.cs;

import android.ranging.raw.RawRangingDevice;

/**
 * BleCsRangingParams encapsulates the parameters required for a bluetooth channel sounding ranging
 * session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BleCsRangingParams implements android.os.Parcelable {

BleCsRangingParams() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the location type for the ranging session.
 *
 * @return the location type.

 * Value is {@link android.ranging.ble.cs.BleCsRangingParams#LOCATION_TYPE_UNKNOWN}, {@link android.ranging.ble.cs.BleCsRangingParams#LOCATION_TYPE_INDOOR}, or {@link android.ranging.ble.cs.BleCsRangingParams#LOCATION_TYPE_OUTDOOR}
 */

public int getLocationType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the Bluetooth address of the peer device.
 *
 * @return String representing the Bluetooth address.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPeerBluetoothAddress() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranging update rate.
 *
 * @return ranging update rate.

 * Value is {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_NORMAL}, {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_INFREQUENT}, or {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_FREQUENT}
 */

public int getRangingUpdateRate() { throw new RuntimeException("Stub!"); }

/**
 * Returns the security level for the ranging session.
 *
 * @return the security level

 * Value is {@link android.ranging.ble.cs.BleCsRangingCapabilities#CS_SECURITY_LEVEL_ONE}, or {@link android.ranging.ble.cs.BleCsRangingCapabilities#CS_SECURITY_LEVEL_FOUR}
 */

public int getSecurityLevel() { throw new RuntimeException("Stub!"); }

/**
 * Returns the sight type for this ranging session.
 *
 * @return the sight type

 * Value is {@link android.ranging.ble.cs.BleCsRangingParams#SIGHT_TYPE_UNKNOWN}, {@link android.ranging.ble.cs.BleCsRangingParams#SIGHT_TYPE_LINE_OF_SIGHT}, or {@link android.ranging.ble.cs.BleCsRangingParams#SIGHT_TYPE_NON_LINE_OF_SIGHT}
 */

public int getSightType() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.ble.cs.BleCsRangingParams> CREATOR;
static { CREATOR = null; }

/**
 * Location of the device is indoor.
 */

public static final int LOCATION_TYPE_INDOOR = 1; // 0x1

/**
 * Location of the device is outdoor.
 */

public static final int LOCATION_TYPE_OUTDOOR = 2; // 0x2

/**
 * Location of the device is unknown.
 */

public static final int LOCATION_TYPE_UNKNOWN = 0; // 0x0

/**
 * Remote device is in line of sight.
 */

public static final int SIGHT_TYPE_LINE_OF_SIGHT = 1; // 0x1

/**
 * Remote device is not in line of sight.
 */

public static final int SIGHT_TYPE_NON_LINE_OF_SIGHT = 2; // 0x2

/**
 * Sight type is unknown.
 */

public static final int SIGHT_TYPE_UNKNOWN = 0; // 0x0
/**
 * Builder class to create {@link android.ranging.ble.cs.BleCsRangingParams BleCsRangingParams} instances.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a new {@link android.ranging.ble.cs.BleCsRangingParams.Builder Builder} for creating a channel sounding ranging session.
 *
 * <p>Valid Bluetooth hardware addresses must be upper case, in big endian byte order, and
 * in a format such as "00:11:22:33:AA:BB". The helper
 * {@link android.bluetooth.BluetoothAdapter#checkBluetoothAddress} is available to validate
 * a Bluetooth address.
 *
 * @param peerBluetoothAddress The address of the peer device must be non-null Bluetooth
 *                             address.
 * @throws java.lang.IllegalArgumentException if {@code peerBluetoothAddress} is null or does not
 *                                  conform to "00:11:22:33:AA:BB" format.
 * @see android.bluetooth.BluetoothDevice#getAddress()
 */

public Builder(@android.annotation.NonNull java.lang.String peerBluetoothAddress) { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns a {@link android.ranging.ble.cs.BleCsRangingParams BleCsRangingParams} instance.
 *
 * @return a new {@link android.ranging.ble.cs.BleCsRangingParams BleCsRangingParams}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.ble.cs.BleCsRangingParams build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the location type for the ranging session.
 * <p>Defaults to {@link #LOCATION_TYPE_UNKNOWN}
 *
 * @param locationType the location type.
 * Value is {@link android.ranging.ble.cs.BleCsRangingParams#LOCATION_TYPE_UNKNOWN}, {@link android.ranging.ble.cs.BleCsRangingParams#LOCATION_TYPE_INDOOR}, or {@link android.ranging.ble.cs.BleCsRangingParams#LOCATION_TYPE_OUTDOOR}
 * @return this {@link android.ranging.ble.cs.BleCsRangingParams.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.ble.cs.BleCsRangingParams.Builder setLocationType(int locationType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the update rate for the CS ranging session.
 * <p>Defaults to {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate#UPDATE_RATE_NORMAL RangingUpdateRate.UPDATE_RATE_NORMAL}
 *
 * @param updateRate the reporting frequency.
 * Value is {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_NORMAL}, {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_INFREQUENT}, or {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_FREQUENT}
 * @return this {@link android.ranging.ble.cs.BleCsRangingParams.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.ble.cs.BleCsRangingParams.Builder setRangingUpdateRate(int updateRate) { throw new RuntimeException("Stub!"); }

/**
 * Sets the security level for the ranging session.
 * <p>Defaults to {@link android.ranging.ble.cs.BleCsRangingCapabilities#CS_SECURITY_LEVEL_ONE BleCsRangingCapabilities.CS_SECURITY_LEVEL_ONE}
 *
 * @param securityLevel the security level.
 * Value is {@link android.ranging.ble.cs.BleCsRangingCapabilities#CS_SECURITY_LEVEL_ONE}, or {@link android.ranging.ble.cs.BleCsRangingCapabilities#CS_SECURITY_LEVEL_FOUR}
 * @return this {@link android.ranging.ble.cs.BleCsRangingParams.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.ble.cs.BleCsRangingParams.Builder setSecurityLevel(int securityLevel) { throw new RuntimeException("Stub!"); }

/**
 * Sets the sight type for the ranging session.
 * <p>Defaults to {@link #SIGHT_TYPE_UNKNOWN}
 *
 * @param sightType the sight type.
 * Value is {@link android.ranging.ble.cs.BleCsRangingParams#SIGHT_TYPE_UNKNOWN}, {@link android.ranging.ble.cs.BleCsRangingParams#SIGHT_TYPE_LINE_OF_SIGHT}, or {@link android.ranging.ble.cs.BleCsRangingParams#SIGHT_TYPE_NON_LINE_OF_SIGHT}
 * @return this {@link android.ranging.ble.cs.BleCsRangingParams.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.ble.cs.BleCsRangingParams.Builder setSightType(int sightType) { throw new RuntimeException("Stub!"); }
}

}

