/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging;


/**
 * Defines the ranging session configurations.
 *
 * <p>This class allows apps to set various parameters related to a ranging session.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SessionConfig implements android.os.Parcelable {

SessionConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the data notification configuration for this preference.
 *
 * @return a non-null {@link android.ranging.DataNotificationConfig DataNotificationConfig} instance.
 */

@android.annotation.NonNull
public android.ranging.DataNotificationConfig getDataNotificationConfig() { throw new RuntimeException("Stub!"); }

/**
 * Returns the configured ranging measurements limit for the ranging session.

 * @return Value is between 0 and 65535 inclusive
 */

public int getRangingMeasurementsLimit() { throw new RuntimeException("Stub!"); }

/**
 * Returns the sensor fusion parameters used for this preference.
 *
 * @return a non-null {@link android.ranging.SensorFusionParams SensorFusionParams} instance.
 */

@android.annotation.NonNull
public android.ranging.SensorFusionParams getSensorFusionParams() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns whether Angle-of-arrival was requested by the app.
 */

public boolean isAngleOfArrivalNeeded() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.SessionConfig> CREATOR;
static { CREATOR = null; }
/**
 * Builder for creating instances of {@link android.ranging.SessionConfig SessionConfig}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds a new {@link android.ranging.SessionConfig SessionConfig} instance.
 *
 * @return the new {@link android.ranging.SessionConfig SessionConfig} instance.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.SessionConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether Angle of Arrival (AoA) is required for the ranging operation.
 *
 * <p> Defaults to false
 *
 * @param isAngleOfArrivalNeeded {@code true} if AoA data is required; {@code false}
 *                               otherwise.
 * @return The {@link android.ranging.SessionConfig.Builder Builder} instance.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.SessionConfig.Builder setAngleOfArrivalNeeded(boolean isAngleOfArrivalNeeded) { throw new RuntimeException("Stub!"); }

/**
 * Sets the data notification configuration for this preference.
 *
 * @param config the {@link android.ranging.DataNotificationConfig DataNotificationConfig} to use.
 * This value cannot be {@code null}.
 * @return the builder instance for chaining.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the config is null.
 */

@android.annotation.NonNull
public android.ranging.SessionConfig.Builder setDataNotificationConfig(@android.annotation.NonNull android.ranging.DataNotificationConfig config) { throw new RuntimeException("Stub!"); }

/**
 * Sets the maximum number of ranging rounds for this session. This includes all ranging
 * rounds, irrespective of whether they were successful or not. For 1:many sessions, a round
 * includes ranging to all peers within that round.
 *
 * <p> By default, when the value is set to {@code 0}, the ranging session will run
 * indefinitely.
 *
 * @param rangingMeasurementsLimit the maximum number of ranging rounds (0 to 65535).
 * Value is between 0 and 65535 inclusive
 * @return this {@link android.ranging.SessionConfig.Builder Builder} instance.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the value is outside the allowed range (0 to 65535).
 */

@android.annotation.NonNull
public android.ranging.SessionConfig.Builder setRangingMeasurementsLimit(int rangingMeasurementsLimit) { throw new RuntimeException("Stub!"); }

/**
 * Sets the sensor fusion parameters for this preference.
 *
 * @param parameters the {@link android.ranging.SensorFusionParams SensorFusionParams} to use.
 * This value cannot be {@code null}.
 * @return the builder instance.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the parameters is null.
 */

@android.annotation.NonNull
public android.ranging.SessionConfig.Builder setSensorFusionParams(@android.annotation.NonNull android.ranging.SensorFusionParams parameters) { throw new RuntimeException("Stub!"); }
}

}

