/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging;


/**
 * Represents the parameters for sensor fusion in ranging operations. Uses IMU sensors to correct
 * HW AOA measurements. Adds a moving average filter for distance measurements to remove outliers.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SensorFusionParams implements android.os.Parcelable {

SensorFusionParams() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Gets whether sensor fusion was requested.
 *
 * @return true if sensor fusion is enabled; false otherwise.
 */

public boolean isSensorFusionEnabled() { throw new RuntimeException("Stub!"); }

/** @hide */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.SensorFusionParams> CREATOR;
static { CREATOR = null; }
/**
 * Builder class for creating instances of {@link android.ranging.SensorFusionParams SensorFusionParams}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds a new instance of {@link android.ranging.SensorFusionParams SensorFusionParams}.
 *
 * @return a new {@link android.ranging.SensorFusionParams SensorFusionParams} instance created using the current state of
 * the builder.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.SensorFusionParams build() { throw new RuntimeException("Stub!"); }

/**
 * Sets whether to use sensor fusion.
 * <p> defaults to true.
 *
 * @param sensorFusionEnabled true to enable sensor fusion; false to disable it.
 * @return this Builder instance for method chaining.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.SensorFusionParams.Builder setSensorFusionEnabled(boolean sensorFusionEnabled) { throw new RuntimeException("Stub!"); }
}

}

