/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging;

import java.util.UUID;

/**
 * Represents a ranging device identified by a unique UUID.
 *
 * <p> This class is designed for ranging operations, where each device involved in the ranging
 * session is uniquely identified by a {@link java.util.UUID UUID}.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RangingDevice implements android.os.Parcelable {

RangingDevice() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Returns the UUID that uniquely identifies the ranging device.
 *
 * @return The device's {@link java.util.UUID UUID}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.UUID getUuid() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.RangingDevice> CREATOR;
static { CREATOR = null; }
/**
 * A builder class for creating instances of {@link android.ranging.RangingDevice RangingDevice}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds a new instance of {@link android.ranging.RangingDevice RangingDevice} with the provided configuration.
 *
 * @return A new {@link android.ranging.RangingDevice RangingDevice} instance.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.RangingDevice build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the UUID for the device.
 *
 * @param id The {@link java.util.UUID UUID} to assign to the device.
 * This value cannot be {@code null}.
 * @return This {@link android.ranging.RangingDevice.Builder Builder} instance.
 *
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided UUID is null.
 */

@android.annotation.NonNull
public android.ranging.RangingDevice.Builder setUuid(@android.annotation.NonNull java.util.UUID id) { throw new RuntimeException("Stub!"); }
}

}

