/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging;


/**
 * Represents ranging data, including distance, azimuth, elevation, and RSSI measurements,
 * along with the ranging technology used and a timestamp.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RangingData implements android.os.Parcelable {

RangingData() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the azimuth measurement, or {@code null} if not available.
 *
 * @return The {@link android.ranging.RangingMeasurement RangingMeasurement} representing the azimuth, or {@code null}.
 */

@android.annotation.Nullable
public android.ranging.RangingMeasurement getAzimuth() { throw new RuntimeException("Stub!"); }

/**
 * Returns the distance measurement.
 *
 * @return The {@link android.ranging.RangingMeasurement RangingMeasurement} representing the distance.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.ranging.RangingMeasurement getDistance() { throw new RuntimeException("Stub!"); }

/**
 * Returns the elevation measurement, or {@code null} if not available.
 *
 * @return The {@link android.ranging.RangingMeasurement RangingMeasurement} representing the elevation, or {@code null}.
 */

@android.annotation.Nullable
public android.ranging.RangingMeasurement getElevation() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranging technology used.
 *
 * @return The ranging technology as an integer.

 * Value is {@link android.ranging.RangingManager#UWB}, {@link android.ranging.RangingManager#BLE_CS}, {@link android.ranging.RangingManager#WIFI_NAN_RTT}, or {@link android.ranging.RangingManager#BLE_RSSI}
 */

public int getRangingTechnology() { throw new RuntimeException("Stub!"); }

/**
 * Returns the RSSI (Received Signal Strength Indicator) value.
 *
 * @return The RSSI value as an integer.
 * @throws java.lang.IllegalStateException if rssi is not set.
 */

public int getRssi() { throw new RuntimeException("Stub!"); }

/**
 * Returns the timestamp of when the ranging data was collected.
 *
 * <br>
 * Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.
 * @return The timestamp in milliseconds.

 * Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.
 */

public long getTimestampMillis() { throw new RuntimeException("Stub!"); }

/**
 * Returns whether an RSSI measurement is included with the data.
 *
 * @return The RSSI value as an integer.
 */

public boolean hasRssi() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.RangingData> CREATOR;
static { CREATOR = null; }
}

