/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging;

import android.ranging.oob.OobInitiatorRangingConfig;
import android.ranging.oob.OobResponderRangingConfig;
import android.ranging.raw.RawInitiatorRangingConfig;
import android.ranging.raw.RawResponderRangingConfig;

/**
 * Abstract class to represent type of ranging configuration.
 *
 * <p>Subclasses include:</p>
 * <ul>
 *     <li>{@link android.ranging.raw.RawResponderRangingConfig RawResponderRangingConfig}</li>
 *     <li>{@link android.ranging.raw.RawInitiatorRangingConfig RawInitiatorRangingConfig}</li>
 *     <li>{@link android.ranging.oob.OobResponderRangingConfig OobResponderRangingConfig}</li>
 *     <li>{@link android.ranging.oob.OobInitiatorRangingConfig OobInitiatorRangingConfig}</li>
 * </ul>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class RangingConfig implements android.os.Parcelable {

protected RangingConfig() { throw new RuntimeException("Stub!"); }

/**
 * Gets the ranging session type {@link android.ranging.RangingConfig.RangingSessionType RangingSessionType}
 *
 * @return the type of ranging session.
 */

public int getRangingSessionType() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** Ranging session with the out-of-band negotiations performed by the ranging API. */

public static final int RANGING_SESSION_OOB = 1; // 0x1

/** Ranging session with the out-of-band negotiations performed by the app. */

public static final int RANGING_SESSION_RAW = 0; // 0x0
}

