/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging;

import android.ranging.ble.cs.BleCsRangingCapabilities;
import android.ranging.uwb.UwbRangingCapabilities;
import android.ranging.wifi.rtt.RttRangingCapabilities;
import java.util.Map;

/**
 * Represents the capabilities and availability of various ranging technologies.
 *
 * <p>The {@code RangingCapabilities} class encapsulates the status of different ranging
 * technologies. It also allows querying the availability of other ranging technologies through a
 * mapping of technology identifiers to availability statuses.</p>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RangingCapabilities implements android.os.Parcelable {

RangingCapabilities() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Gets the BLE channel sounding ranging capabilities.
 *
 * @return a {@link android.ranging.ble.cs.BleCsRangingCapabilities BleCsRangingCapabilities} object or {@code null} if not available.
 */

@android.annotation.Nullable
public android.ranging.ble.cs.BleCsRangingCapabilities getCsCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * Gets the WiFi NAN-RTT ranging capabilities.
 *
 * @return a {@link android.ranging.wifi.rtt.RttRangingCapabilities RttRangingCapabilities} object or {@code null} if not available.
 */

@android.annotation.Nullable
public android.ranging.wifi.rtt.RttRangingCapabilities getRttRangingCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * Gets a map containing the availability of various ranging technologies.
 *
 * <p>The map uses technology identifiers as keys and their respective availability
 * statuses as values.</p>
 *
 * @return a {@link java.util.Map Map} with key {@link android.ranging.RangingManager.RangingTechnology RangingTechnology} and value
 * {@link android.ranging.RangingCapabilities.RangingTechnologyAvailability RangingTechnologyAvailability}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.Integer,java.lang.Integer> getTechnologyAvailability() { throw new RuntimeException("Stub!"); }

/**
 * Gets the UWB ranging capabilities.
 *
 * @return a {@link android.ranging.uwb.UwbRangingCapabilities UwbRangingCapabilities} object or {@code null} if not available.
 */

@android.annotation.Nullable
public android.ranging.uwb.UwbRangingCapabilities getUwbCapabilities() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.RangingCapabilities> CREATOR;
static { CREATOR = null; }

/**
 * Indicates that the ranging technology is disabled due to regulatory restrictions.
 */

public static final int DISABLED_REGULATORY = 2; // 0x2

/**
 * Indicates that the ranging technology is disabled by the user.
 */

public static final int DISABLED_USER = 1; // 0x1

/**
 * Indicates that the ranging technology is disabled due to device usage restrictions.
 */

public static final int DISABLED_USER_RESTRICTIONS = 4; // 0x4

/**
 * Indicates that the ranging technology is enabled and available for use.
 */

public static final int ENABLED = 3; // 0x3

/**
 * Indicates that the ranging technology is not supported on the current device.
 */

public static final int NOT_SUPPORTED = 0; // 0x0
}

