/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging;


/**
 * Represents the configuration for data notifications in ranging operations.
 *
 * <p>This class holds the configuration settings for how notifications are sent
 * regarding the proximity of ranging devices.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DataNotificationConfig implements android.os.Parcelable {

DataNotificationConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the configured notification configuration type.
 *
 * @return the notification configuration type.
 *

 * Value is {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_DISABLE}, {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_ENABLE}, {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_PROXIMITY_LEVEL}, or {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_PROXIMITY_EDGE}
 */

public int getNotificationConfigType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the far proximity threshold in centimeters.
 *
 * @return the far proximity in centimeters.

 * Value is between 0 and 20000 inclusive
 */

public int getProximityFarCm() { throw new RuntimeException("Stub!"); }

/**
 * Returns the near proximity threshold in centimeters.
 *
 * @return the near proximity in centimeters.

 * Value is between 0 and 20000 inclusive
 */

public int getProximityNearCm() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.DataNotificationConfig> CREATOR;
static { CREATOR = null; }

public static final int NOTIFICATION_CONFIG_DISABLE = 0; // 0x0

public static final int NOTIFICATION_CONFIG_ENABLE = 1; // 0x1

public static final int NOTIFICATION_CONFIG_PROXIMITY_EDGE = 3; // 0x3

public static final int NOTIFICATION_CONFIG_PROXIMITY_LEVEL = 2; // 0x2
/** Builder for {@link android.ranging.DataNotificationConfig DataNotificationConfig} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds a new instance of {@link android.ranging.DataNotificationConfig DataNotificationConfig}.
 *
 * @return a new {@link android.ranging.DataNotificationConfig DataNotificationConfig} instance created using the current state of
 * the builder.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.DataNotificationConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the notification configuration type.
 *  <p> defaults to {@link android.ranging.DataNotificationConfig.NotificationConfigType#NOTIFICATION_CONFIG_ENABLE NotificationConfigType.NOTIFICATION_CONFIG_ENABLE}
 *
 * @param config The notification configuration type to set.
 * Value is {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_DISABLE}, {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_ENABLE}, {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_PROXIMITY_LEVEL}, or {@link android.ranging.DataNotificationConfig#NOTIFICATION_CONFIG_PROXIMITY_EDGE}
 * @return this Builder instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.DataNotificationConfig.Builder setNotificationConfigType(int config) { throw new RuntimeException("Stub!"); }

/**
 * Sets the far proximity threshold in centimeters.
 * <p> defaults to 20000 cm.
 *
 * @param proximityCm The far proximity to set, in centimeters.
 * Value is between 0 and 20000 inclusive
 * @return this Builder instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.DataNotificationConfig.Builder setProximityFarCm(int proximityCm) { throw new RuntimeException("Stub!"); }

/**
 * Sets the near proximity threshold in centimeters.
 * <p> defaults to 0 cm.
 *
 * @param proximityCm The near proximity to set, in centimeters.
 * Value is between 0 and 20000 inclusive
 * @return this Builder instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.DataNotificationConfig.Builder setProximityNearCm(int proximityCm) { throw new RuntimeException("Stub!"); }
}

}

