/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.provider;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class E2eeContactKeysManager {

E2eeContactKeysManager() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.provider.E2eeContactKeysManager.E2eeContactKey> getAllE2eeContactKeys(@android.annotation.NonNull java.lang.String lookupKey) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.provider.E2eeContactKeysManager.E2eeSelfKey> getAllE2eeSelfKeys() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.provider.E2eeContactKeysManager.E2eeContactKey getE2eeContactKey(@android.annotation.NonNull java.lang.String lookupKey, @android.annotation.NonNull java.lang.String deviceId, @android.annotation.NonNull java.lang.String accountId) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.provider.E2eeContactKeysManager.E2eeSelfKey getE2eeSelfKey(@android.annotation.NonNull java.lang.String deviceId, @android.annotation.NonNull java.lang.String accountId) { throw new RuntimeException("Stub!"); }

public static int getMaxKeySizeBytes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.provider.E2eeContactKeysManager.E2eeContactKey> getOwnerE2eeContactKeys(@android.annotation.NonNull java.lang.String lookupKey) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.provider.E2eeContactKeysManager.E2eeSelfKey> getOwnerE2eeSelfKeys() { throw new RuntimeException("Stub!"); }

public boolean removeE2eeContactKey(@android.annotation.NonNull java.lang.String lookupKey, @android.annotation.NonNull java.lang.String deviceId, @android.annotation.NonNull java.lang.String accountId) { throw new RuntimeException("Stub!"); }

public boolean removeE2eeSelfKey(@android.annotation.NonNull java.lang.String deviceId, @android.annotation.NonNull java.lang.String accountId) { throw new RuntimeException("Stub!"); }

public boolean updateE2eeContactKeyLocalVerificationState(@android.annotation.NonNull java.lang.String lookupKey, @android.annotation.NonNull java.lang.String deviceId, @android.annotation.NonNull java.lang.String accountId, int localVerificationState) { throw new RuntimeException("Stub!"); }

public boolean updateE2eeContactKeyRemoteVerificationState(@android.annotation.NonNull java.lang.String lookupKey, @android.annotation.NonNull java.lang.String deviceId, @android.annotation.NonNull java.lang.String accountId, int remoteVerificationState) { throw new RuntimeException("Stub!"); }

public boolean updateE2eeSelfKeyRemoteVerificationState(@android.annotation.NonNull java.lang.String deviceId, @android.annotation.NonNull java.lang.String accountId, int remoteVerificationState) { throw new RuntimeException("Stub!"); }

public void updateOrInsertE2eeContactKey(@android.annotation.NonNull java.lang.String lookupKey, @android.annotation.NonNull java.lang.String deviceId, @android.annotation.NonNull java.lang.String accountId, @android.annotation.NonNull byte[] keyValue) { throw new RuntimeException("Stub!"); }

public boolean updateOrInsertE2eeSelfKey(@android.annotation.NonNull java.lang.String deviceId, @android.annotation.NonNull java.lang.String accountId, @android.annotation.NonNull byte[] keyValue) { throw new RuntimeException("Stub!"); }

public static final int VERIFICATION_STATE_UNVERIFIED = 0; // 0x0

public static final int VERIFICATION_STATE_VERIFICATION_FAILED = 1; // 0x1

public static final int VERIFICATION_STATE_VERIFIED = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class E2eeContactKey implements android.os.Parcelable {

E2eeContactKey() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getAccountId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getDeviceId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getDisplayName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getEmailAddress() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getKeyValue() { throw new RuntimeException("Stub!"); }

public int getLocalVerificationState() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getOwnerPackageName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getPhoneNumber() { throw new RuntimeException("Stub!"); }

public int getRemoteVerificationState() { throw new RuntimeException("Stub!"); }

public long getTimeUpdated() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.provider.E2eeContactKeysManager.E2eeContactKey> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class E2eeSelfKey implements android.os.Parcelable {

E2eeSelfKey() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getAccountId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getDeviceId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getKeyValue() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getOwnerPackageName() { throw new RuntimeException("Stub!"); }

public int getRemoteVerificationState() { throw new RuntimeException("Stub!"); }

public long getTimeUpdated() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.provider.E2eeContactKeysManager.E2eeSelfKey> CREATOR;
static { CREATOR = null; }
}

}

