/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.os.storage;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class StorageManager {

StorageManager() { throw new RuntimeException("Stub!"); }

public void allocateBytes(java.io.FileDescriptor fd, long bytes) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void allocateBytes(@android.annotation.NonNull java.util.UUID storageUuid, long bytes) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public long getAllocatableBytes(@android.annotation.NonNull java.util.UUID storageUuid) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public long getCacheQuotaBytes(@android.annotation.NonNull java.util.UUID storageUuid) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public long getCacheSizeBytes(@android.annotation.NonNull java.util.UUID storageUuid) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.PendingIntent getManageSpaceActivityIntent(@android.annotation.NonNull java.lang.String packageName, int requestCode) { throw new RuntimeException("Stub!"); }

public java.lang.String getMountedObbPath(java.lang.String rawPath) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.storage.StorageVolume getPrimaryStorageVolume() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.os.storage.StorageVolume> getRecentStorageVolumes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.storage.StorageVolume getStorageVolume(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.storage.StorageVolume getStorageVolume(@android.annotation.NonNull java.io.File file) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.os.storage.StorageVolume> getStorageVolumes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.os.storage.StorageVolume> getStorageVolumesIncludingSharedProfiles() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.UUID getUuidForPath(@android.annotation.NonNull java.io.File path) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public boolean isAllocationSupported(@android.annotation.NonNull java.io.FileDescriptor fd) { throw new RuntimeException("Stub!"); }

public boolean isCacheBehaviorGroup(java.io.File path) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public boolean isCacheBehaviorTombstone(java.io.File path) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public boolean isCheckpointSupported() { throw new RuntimeException("Stub!"); }

public boolean isEncrypted(java.io.File file) { throw new RuntimeException("Stub!"); }

public boolean isObbMounted(java.lang.String rawPath) { throw new RuntimeException("Stub!"); }

public boolean mountObb(java.lang.String rawPath, java.lang.String key, android.os.storage.OnObbStateChangeListener listener) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.ParcelFileDescriptor openProxyFileDescriptor(int mode, android.os.ProxyFileDescriptorCallback callback, android.os.Handler handler) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void registerStorageVolumeCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.storage.StorageManager.StorageVolumeCallback callback) { throw new RuntimeException("Stub!"); }

public void setCacheBehaviorGroup(java.io.File path, boolean group) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void setCacheBehaviorTombstone(java.io.File path, boolean tombstone) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public boolean unmountObb(java.lang.String rawPath, boolean force, android.os.storage.OnObbStateChangeListener listener) { throw new RuntimeException("Stub!"); }

public void unregisterStorageVolumeCallback(@android.annotation.NonNull android.os.storage.StorageManager.StorageVolumeCallback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_CLEAR_APP_CACHE = "android.os.storage.action.CLEAR_APP_CACHE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_MANAGE_STORAGE = "android.os.storage.action.MANAGE_STORAGE";

public static final java.lang.String EXTRA_REQUESTED_BYTES = "android.os.storage.extra.REQUESTED_BYTES";

public static final java.lang.String EXTRA_UUID = "android.os.storage.extra.UUID";

public static final java.util.UUID UUID_DEFAULT;
static { UUID_DEFAULT = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class StorageVolumeCallback {

public StorageVolumeCallback() { throw new RuntimeException("Stub!"); }

public void onStateChanged(@android.annotation.NonNull android.os.storage.StorageVolume volume) { throw new RuntimeException("Stub!"); }
}

}

