/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.os.flagging;


/**
 * Exception thrown when an error occurs while reading from Aconfig Storage.
 *
 * <p>This exception indicates a problem accessing or retrieving configuration data from Aconfig
 * Storage. This could be due to various reasons, such as:
 *
 * <ul>
 *   <li>The Aconfig Storage system is not found on the device.
 *   <li>The requested configuration package is not found.
 *   <li>The specified container is not found.
 *   <li>There was an error reading the Aconfig Storage file.
 *   <li>The fingerprint of the Aconfig Storage file does not match the expected fingerprint.
 * </ul>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AconfigStorageReadException extends java.lang.RuntimeException {

/**
 * Constructs a new {@code AconfigStorageReadException} with the specified error code and detail
 * message.
 *
 * @param errorCode The error code for this exception.
 * Value is {@link android.os.flagging.AconfigStorageReadException#ERROR_GENERIC}, {@link android.os.flagging.AconfigStorageReadException#ERROR_STORAGE_SYSTEM_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_PACKAGE_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_CONTAINER_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_CANNOT_READ_STORAGE_FILE}, or android.os.flagging.AconfigStorageReadException.ERROR_FILE_FINGERPRINT_MISMATCH
 * @param msg The detail message for this exception.

 * This value cannot be {@code null}.
 */

public AconfigStorageReadException(int errorCode, @android.annotation.NonNull java.lang.String msg) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@code AconfigStorageReadException} with the specified error code, detail
 * message, and cause.
 *
 * @param errorCode The error code for this exception.
 * Value is {@link android.os.flagging.AconfigStorageReadException#ERROR_GENERIC}, {@link android.os.flagging.AconfigStorageReadException#ERROR_STORAGE_SYSTEM_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_PACKAGE_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_CONTAINER_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_CANNOT_READ_STORAGE_FILE}, or android.os.flagging.AconfigStorageReadException.ERROR_FILE_FINGERPRINT_MISMATCH
 * @param msg The detail message for this exception.
 * This value cannot be {@code null}.
 * @param cause The cause of this exception.

 * This value cannot be {@code null}.
 */

public AconfigStorageReadException(int errorCode, @android.annotation.NonNull java.lang.String msg, @android.annotation.NonNull java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@code AconfigStorageReadException} with the specified error code and cause.
 *
 * @param errorCode The error code for this exception.
 * Value is {@link android.os.flagging.AconfigStorageReadException#ERROR_GENERIC}, {@link android.os.flagging.AconfigStorageReadException#ERROR_STORAGE_SYSTEM_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_PACKAGE_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_CONTAINER_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_CANNOT_READ_STORAGE_FILE}, or android.os.flagging.AconfigStorageReadException.ERROR_FILE_FINGERPRINT_MISMATCH
 * @param cause The cause of this exception.

 * This value cannot be {@code null}.
 */

public AconfigStorageReadException(int errorCode, @android.annotation.NonNull java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }

/**
 * Returns the error code associated with this exception.
 *
 * @return The error code.

 * Value is {@link android.os.flagging.AconfigStorageReadException#ERROR_GENERIC}, {@link android.os.flagging.AconfigStorageReadException#ERROR_STORAGE_SYSTEM_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_PACKAGE_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_CONTAINER_NOT_FOUND}, {@link android.os.flagging.AconfigStorageReadException#ERROR_CANNOT_READ_STORAGE_FILE}, or android.os.flagging.AconfigStorageReadException.ERROR_FILE_FINGERPRINT_MISMATCH
 */

public int getErrorCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns the error message for this exception, including the error code and the original
 * message.
 *
 * @return The error message.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getMessage() { throw new RuntimeException("Stub!"); }

/** Error code indicating that there was an error reading the Aconfig Storage file. */

public static final int ERROR_CANNOT_READ_STORAGE_FILE = 4; // 0x4

/** Error code indicating that the specified container is not found. */

public static final int ERROR_CONTAINER_NOT_FOUND = 3; // 0x3

/** Generic error code indicating an unspecified Aconfig Storage error. */

public static final int ERROR_GENERIC = 0; // 0x0

/** Error code indicating that the requested configuration package is not found. */

public static final int ERROR_PACKAGE_NOT_FOUND = 2; // 0x2

/** Error code indicating that the Aconfig Storage system is not found on the device. */

public static final int ERROR_STORAGE_SYSTEM_NOT_FOUND = 1; // 0x1
}

