/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.os.flagging;


/**
 * An {@code aconfig} package containing the enabled state of its flags.
 *
 * <p><strong>Note: this is intended only to be used by generated code. To determine if a given flag
 * is enabled in app code, the generated android flags should be used.</strong>
 *
 * <p>This class is used to read the flag from Aconfig Package.Each instance of this class will
 * cache information related to one package. To read flags from a different package, a new instance
 * of this class should be {@link #load loaded}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AconfigPackage {

AconfigPackage() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the value of a boolean flag.
 *
 * <p>This method retrieves the value of the specified flag. If the flag exists within the
 * loaded Aconfig Package, its value is returned. Otherwise, the provided `defaultValue` is
 * returned.
 *
 * @param flagName The name of the flag (excluding any package name prefix).
 * This value cannot be {@code null}.
 * @param defaultValue The value to return if the flag is not found.
 * @return The boolean value of the flag, or `defaultValue` if the flag is not found.
 */

public boolean getBooleanFlagValue(@android.annotation.NonNull java.lang.String flagName, boolean defaultValue) { throw new RuntimeException("Stub!"); }

/**
 * Loads an Aconfig Package from Aconfig Storage.
 *
 * <p>This method attempts to load the specified Aconfig package.
 *
 * @param packageName The name of the Aconfig package to load.
 * This value cannot be {@code null}.
 * @return An instance of {@link android.os.flagging.AconfigPackage AconfigPackage}, which may be empty if the package is not found
 *     in the container.
 * This value cannot be {@code null}.
 * @throws android.os.flagging.AconfigStorageReadException if there is an error reading from Aconfig Storage, such
 *     as if the storage system is not found, the package is not found, or there is an error
 *     reading the storage file. The specific error code can be obtained using {@link android.os.flagging.AconfigStorageReadException#getErrorCode()      }.
 */

@android.annotation.NonNull
public static android.os.flagging.AconfigPackage load(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }
}

