/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.os;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class BatteryManager {

BatteryManager() { throw new RuntimeException("Stub!"); }

public long computeChargeTimeRemaining() { throw new RuntimeException("Stub!"); }

public int getIntProperty(int id) { throw new RuntimeException("Stub!"); }

public long getLongProperty(int id) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getStringProperty(int id) { throw new RuntimeException("Stub!"); }

public boolean isCharging() { throw new RuntimeException("Stub!"); }

public static final java.lang.String ACTION_CHARGING = "android.os.action.CHARGING";

public static final java.lang.String ACTION_DISCHARGING = "android.os.action.DISCHARGING";

public static final int BATTERY_CAPACITY_LEVEL_CRITICAL = 1; // 0x1

public static final int BATTERY_CAPACITY_LEVEL_FULL = 5; // 0x5

public static final int BATTERY_CAPACITY_LEVEL_HIGH = 4; // 0x4

public static final int BATTERY_CAPACITY_LEVEL_LOW = 2; // 0x2

public static final int BATTERY_CAPACITY_LEVEL_NORMAL = 3; // 0x3

public static final int BATTERY_CAPACITY_LEVEL_UNKNOWN = 0; // 0x0

public static final int BATTERY_CAPACITY_LEVEL_UNSUPPORTED = -1; // 0xffffffff

public static final int BATTERY_HEALTH_COLD = 7; // 0x7

public static final int BATTERY_HEALTH_DEAD = 4; // 0x4

public static final int BATTERY_HEALTH_GOOD = 2; // 0x2

public static final int BATTERY_HEALTH_OVERHEAT = 3; // 0x3

public static final int BATTERY_HEALTH_OVER_VOLTAGE = 5; // 0x5

public static final int BATTERY_HEALTH_UNKNOWN = 1; // 0x1

public static final int BATTERY_HEALTH_UNSPECIFIED_FAILURE = 6; // 0x6

public static final int BATTERY_PLUGGED_AC = 1; // 0x1

public static final int BATTERY_PLUGGED_DOCK = 8; // 0x8

public static final int BATTERY_PLUGGED_USB = 2; // 0x2

public static final int BATTERY_PLUGGED_WIRELESS = 4; // 0x4

public static final int BATTERY_PROPERTY_CAPACITY = 4; // 0x4

public static final int BATTERY_PROPERTY_CHARGE_COUNTER = 1; // 0x1

public static final int BATTERY_PROPERTY_CURRENT_AVERAGE = 3; // 0x3

public static final int BATTERY_PROPERTY_CURRENT_NOW = 2; // 0x2

public static final int BATTERY_PROPERTY_ENERGY_COUNTER = 5; // 0x5

public static final int BATTERY_PROPERTY_STATUS = 6; // 0x6

public static final int BATTERY_STATUS_CHARGING = 2; // 0x2

public static final int BATTERY_STATUS_DISCHARGING = 3; // 0x3

public static final int BATTERY_STATUS_FULL = 5; // 0x5

public static final int BATTERY_STATUS_NOT_CHARGING = 4; // 0x4

public static final int BATTERY_STATUS_UNKNOWN = 1; // 0x1

public static final java.lang.String EXTRA_BATTERY_LOW = "battery_low";

public static final java.lang.String EXTRA_CAPACITY_LEVEL = "android.os.extra.CAPACITY_LEVEL";

public static final java.lang.String EXTRA_CHARGING_STATUS = "android.os.extra.CHARGING_STATUS";

public static final java.lang.String EXTRA_CYCLE_COUNT = "android.os.extra.CYCLE_COUNT";

public static final java.lang.String EXTRA_HEALTH = "health";

public static final java.lang.String EXTRA_ICON_SMALL = "icon-small";

public static final java.lang.String EXTRA_LEVEL = "level";

public static final java.lang.String EXTRA_PLUGGED = "plugged";

public static final java.lang.String EXTRA_PRESENT = "present";

public static final java.lang.String EXTRA_SCALE = "scale";

public static final java.lang.String EXTRA_STATUS = "status";

public static final java.lang.String EXTRA_TECHNOLOGY = "technology";

public static final java.lang.String EXTRA_TEMPERATURE = "temperature";

public static final java.lang.String EXTRA_VOLTAGE = "voltage";
}

