/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p.nsd;

import android.os.Parcelable;

/**
 * A class for a response for USD based service discovery.
 * For the details of the configuration, refer Wi-Fi Alliance Wi-Fi Direct R2 specification
 * - Appendix H - Unsynchronized Service Discovery (as defined in Wi-Fi Aware) and section
 * 4.2.13 USD frame format.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiP2pUsdBasedServiceResponse implements android.os.Parcelable {

WifiP2pUsdBasedServiceResponse() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Get the service protocol type provided by the peer device in the USD service response.
 * See also {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig.Builder#setServiceProtocolType(int) WifiP2pUsdBasedServiceConfig.Builder.setServiceProtocolType(int)}
 *
 * @return A non-negative service layer protocol type.

 * Value is between 0 and 255 inclusive
 */

public int getServiceProtocolType() { throw new RuntimeException("Stub!"); }

/** Get the service specific information provided by the peer device in the USD service
 * response.
 * See also {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig.Builder#setServiceSpecificInfo(byte[]) WifiP2pUsdBasedServiceConfig.Builder.setServiceSpecificInfo(byte[])}
 *
 *  @return A byte-array of service specification information, or null if unset.
 */

@android.annotation.Nullable
public byte[] getServiceSpecificInfo() { throw new RuntimeException("Stub!"); }

/**
 * Generates a string of all the defined elements.
 *
 * @return a compiled string representing all elements
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceResponse> CREATOR;
static { CREATOR = null; }
}

