/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p.nsd;

import android.os.Parcelable;

/**
 * A class for storing service information that is advertised
 * over a Wi-Fi peer-to-peer setup
 *
 * @see android.net.wifi.p2p.nsd.WifiP2pUpnpServiceInfo
 * @see android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceInfo
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WifiP2pServiceInfo implements android.os.Parcelable {

/**
 * Constructor for creating a service information for advertising the service using
 * un-synchronized service discovery (USD) protocol. Refer Wi-Fi Alliance Wi-Fi Direct R2
 * specification section 3.7 - "Unsynchronized Service Discovery (USD)" for the details.
 *
 * @param usdConfig See {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig WifiP2pUsdBasedServiceConfig}
 *
 * This value cannot be {@code null}.
 * @return service info containing USD based service configuration.
 */

public WifiP2pServiceInfo(@android.annotation.NonNull android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig usdConfig) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface {@hide} */

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Get the service information configured to advertise using un-synchronized service discovery
 * (USD) protocol.
 * See {@link #WifiP2pServiceInfo(android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig)}
 *
 * @return A valid or not null {@link android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig WifiP2pUsdBasedServiceConfig} if the service information
 * is configured to advertise using un-synchronized service discovery (USD) protocol.
 * Otherwise, it is null.
 */

@android.annotation.Nullable
public android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig getWifiP2pUsdBasedServiceConfig() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface {@hide} */

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * All service protocol types.
 */

public static final int SERVICE_TYPE_ALL = 0; // 0x0

/**
 * DNS based service discovery protocol.
 */

public static final int SERVICE_TYPE_BONJOUR = 1; // 0x1

/**
 * UPnP protocol.
 */

public static final int SERVICE_TYPE_UPNP = 2; // 0x2

/**
 * Vendor Specific protocol
 */

public static final int SERVICE_TYPE_VENDOR_SPECIFIC = 255; // 0xff
}

