/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p;

import android.os.Parcelable;

/**
 * A class representing Wi-Fi Direct pairing bootstrapping configuration.
 *
 * @see android.net.wifi.p2p.WifiP2pConfig
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiP2pPairingBootstrappingConfig implements android.os.Parcelable {

/**
 * Constructor for a WifiP2pPairingBootstrappingConfig.
 * @param method One of the {@code PAIRING_BOOTSTRAPPING_METHOD_*}.
 * Value is either <code>0</code> or a combination of {@link android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig#PAIRING_BOOTSTRAPPING_METHOD_OPPORTUNISTIC}, {@link android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig#PAIRING_BOOTSTRAPPING_METHOD_DISPLAY_PINCODE}, {@link android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig#PAIRING_BOOTSTRAPPING_METHOD_DISPLAY_PASSPHRASE}, {@link android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig#PAIRING_BOOTSTRAPPING_METHOD_KEYPAD_PINCODE}, {@link android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig#PAIRING_BOOTSTRAPPING_METHOD_KEYPAD_PASSPHRASE}, and {@link android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig#PAIRING_BOOTSTRAPPING_METHOD_OUT_OF_BAND}
 * @param password Password or PIN for pairing setup. if {@code method} is
 *                 {@link #PAIRING_BOOTSTRAPPING_METHOD_DISPLAY_PINCODE}, the password must be
 *                 a string containing 4 or more digits (0-9). For example: "1234", "56789". if
 *                 {@code method} is {@link #PAIRING_BOOTSTRAPPING_METHOD_DISPLAY_PASSPHRASE}
 *                 or {@link #PAIRING_BOOTSTRAPPING_METHOD_OUT_OF_BAND}, the password must be a
 *                 UTF-8 string of minimum of 1 character.
 *                 The password must be set to null if the
 *                 {@code method} is {@link #PAIRING_BOOTSTRAPPING_METHOD_OPPORTUNISTIC},
 *                 {@link #PAIRING_BOOTSTRAPPING_METHOD_KEYPAD_PINCODE} or
 *                 {@link #PAIRING_BOOTSTRAPPING_METHOD_KEYPAD_PASSPHRASE}.
 *
 * @throws java.lang.IllegalArgumentException if the input pairing bootstrapping method is not
 * one of the {@code PAIRING_BOOTSTRAPPING_METHOD_*}.
 * @throws java.lang.IllegalArgumentException if a non-null password is set for pairing bootstrapping
 * method {@link #PAIRING_BOOTSTRAPPING_METHOD_OPPORTUNISTIC},
 * {@link #PAIRING_BOOTSTRAPPING_METHOD_KEYPAD_PINCODE} or
 * {@link #PAIRING_BOOTSTRAPPING_METHOD_KEYPAD_PASSPHRASE}.
 */

public WifiP2pPairingBootstrappingConfig(int method, @android.annotation.Nullable java.lang.String password) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Generates a string of all the defined elements.
 *
 * @return a compiled string representing all elements
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig> CREATOR;
static { CREATOR = null; }

/**
 * Pairing bootstrapping method display passphrase - The passphrase is displayed on the
 * connection initiating device. The user enters the displayed passphrase on the other device.
 */

public static final int PAIRING_BOOTSTRAPPING_METHOD_DISPLAY_PASSPHRASE = 4; // 0x4

/**
 * Pairing bootstrapping method display pin-code - The pin-code is displayed on the connection
 * initiating device. The user enters the displayed pin-code on the other device.
 */

public static final int PAIRING_BOOTSTRAPPING_METHOD_DISPLAY_PINCODE = 2; // 0x2

/**
 * Pairing bootstrapping method keypad passphrase - The passphrase is displayed on the other
 * device. The user enters the displayed passphrase on the connection initiating device.
 */

public static final int PAIRING_BOOTSTRAPPING_METHOD_KEYPAD_PASSPHRASE = 16; // 0x10

/**
 * Pairing bootstrapping method keypad pin-code - The pin-code is displayed on the other
 * device. The user enters the displayed pin-code on the connection initiating device.
 */

public static final int PAIRING_BOOTSTRAPPING_METHOD_KEYPAD_PINCODE = 8; // 0x8

/**
 * Pairing bootstrapping method opportunistic
 */

public static final int PAIRING_BOOTSTRAPPING_METHOD_OPPORTUNISTIC = 1; // 0x1

/**
 * Pairing bootstrapping done out of band (For example: Over Bluetooth LE.
 * Refer Wi-Fi Alliance Wi-Fi Direct R2 specification Section 3.9 for the details).
 */

public static final int PAIRING_BOOTSTRAPPING_METHOD_OUT_OF_BAND = 32; // 0x20
}

