/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.vcn;

import android.net.NetworkCapabilities;
import java.util.Set;

/**
 * This class represents a configuration for a network template class of underlying Carrier WiFi
 * networks.
 *
 * <p>See {@link android.net.vcn.VcnUnderlyingNetworkTemplate VcnUnderlyingNetworkTemplate}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class VcnWifiUnderlyingNetworkTemplate extends android.net.vcn.VcnUnderlyingNetworkTemplate {

VcnWifiUnderlyingNetworkTemplate() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param other This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

/**
 * Retrieve the matching SSIDs, or an empty set if any SSID is acceptable.
 *
 * @see android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder#setSsids(Set)

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getSsids() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** This class is used to incrementally build VcnWifiUnderlyingNetworkTemplate objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Construct a Builder object. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Build the VcnWifiUnderlyingNetworkTemplate.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnWifiUnderlyingNetworkTemplate build() { throw new RuntimeException("Stub!"); }

/**
 * Set the matching criteria for metered networks.
 *
 * <p>A template where setMetered(MATCH_REQUIRED) will only match metered networks (one
 * without NET_CAPABILITY_NOT_METERED). A template where setMetered(MATCH_FORBIDDEN) will
 * only match a network that is not metered (one with NET_CAPABILITY_NOT_METERED).
 *
 * @param matchCriteria the matching criteria for metered networks. Defaults to {@link
 *     #MATCH_ANY}.
 * Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 * @see android.net.NetworkCapabilities#NET_CAPABILITY_NOT_METERED
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder setMetered(int matchCriteria) { throw new RuntimeException("Stub!"); }

/**
 * Set the minimum upstream bandwidths that this template will match.
 *
 * <p>This template will not match a network that does not provide at least the bandwidth
 * passed as the entry bandwidth, except in the case that the network is selected as the VCN
 * Gateway Connection's underlying network, where it will continue to match until the
 * bandwidth drops under the exit bandwidth.
 *
 * <p>The entry criteria MUST be greater than, or equal to the exit criteria to avoid the
 * invalid case where a network fulfills the entry criteria, but at the same time fails the
 * exit criteria.
 *
 * <p>Estimated bandwidth of a network is provided by the transport layer, and reported in
 * {@link android.net.NetworkCapabilities NetworkCapabilities}. The provided estimates will be used without modification.
 *
 * @param minEntryDownstreamBandwidthKbps the minimum accepted downstream bandwidth for
 *     networks that ARE NOT the already-selected underlying network, or {@code 0} to
 *     disable this requirement. Disabled by default.
 * @param minExitDownstreamBandwidthKbps the minimum accepted downstream bandwidth for a
 *     network that IS the already-selected underlying network, or {@code 0} to disable this
 *     requirement. Disabled by default.
 * @return this {@link android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder Builder} instance, for chaining

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder setMinDownstreamBandwidthKbps(int minEntryDownstreamBandwidthKbps, int minExitDownstreamBandwidthKbps) { throw new RuntimeException("Stub!"); }

/**
 * Set the minimum upstream bandwidths that this template will match.
 *
 * <p>This template will not match a network that does not provide at least the bandwidth
 * passed as the entry bandwidth, except in the case that the network is selected as the VCN
 * Gateway Connection's underlying network, where it will continue to match until the
 * bandwidth drops under the exit bandwidth.
 *
 * <p>The entry criteria MUST be greater than, or equal to the exit criteria to avoid the
 * invalid case where a network fulfills the entry criteria, but at the same time fails the
 * exit criteria.
 *
 * <p>Estimated bandwidth of a network is provided by the transport layer, and reported in
 * {@link android.net.NetworkCapabilities NetworkCapabilities}. The provided estimates will be used without modification.
 *
 * @param minEntryUpstreamBandwidthKbps the minimum accepted upstream bandwidth for networks
 *     that ARE NOT the already-selected underlying network, or {@code 0} to disable this
 *     requirement. Disabled by default.
 * @param minExitUpstreamBandwidthKbps the minimum accepted upstream bandwidth for a network
 *     that IS the already-selected underlying network, or {@code 0} to disable this
 *     requirement. Disabled by default.
 * @return this {@link android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder Builder} instance, for chaining

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder setMinUpstreamBandwidthKbps(int minEntryUpstreamBandwidthKbps, int minExitUpstreamBandwidthKbps) { throw new RuntimeException("Stub!"); }

/**
 * Set the SSIDs with which a network can match this priority rule.
 *
 * @param ssids the matching SSIDs. Network with one of the matching SSIDs can match this
 *     priority rule. If the set is empty, any SSID will match. The default is an empty set.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder setSsids(@android.annotation.NonNull java.util.Set<java.lang.String> ssids) { throw new RuntimeException("Stub!"); }
}

}

