/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.vcn;


/**
 * This class represents a template containing set of underlying network requirements for doing
 * route selection.
 *
 * <p>Apps provisioning a VCN can configure the underlying network priority for each Gateway
 * Connection by setting a list (in priority order, most to least preferred) of the appropriate
 * subclasses in the VcnGatewayConnectionConfig. See {@link android.net.vcn.VcnGatewayConnectionConfig.Builder#setVcnUnderlyingNetworkPriorities  }
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class VcnUnderlyingNetworkTemplate {

VcnUnderlyingNetworkTemplate() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param other This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

/**
 * Return the matching criteria for metered networks.
 *
 * @see android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder#setMetered(int)
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setMetered(int)
 */

public int getMetered() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum entry downstream bandwidth allowed by this template.
 *
 * @see android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder#setMinDownstreamBandwidthKbps(int, int)
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setMinDownstreamBandwidthKbps(int, int)
 */

public int getMinEntryDownstreamBandwidthKbps() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum entry upstream bandwidth allowed by this template.
 *
 * @see android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder#setMinUpstreamBandwidthKbps(int, int)
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setMinUpstreamBandwidthKbps(int, int)
 */

public int getMinEntryUpstreamBandwidthKbps() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum exit downstream bandwidth allowed by this template.
 *
 * @see android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder#setMinDownstreamBandwidthKbps(int, int)
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setMinDownstreamBandwidthKbps(int, int)
 */

public int getMinExitDownstreamBandwidthKbps() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum exit upstream bandwidth allowed by this template.
 *
 * @see android.net.vcn.VcnWifiUnderlyingNetworkTemplate.Builder#setMinUpstreamBandwidthKbps(int, int)
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setMinUpstreamBandwidthKbps(int, int)
 */

public int getMinExitUpstreamBandwidthKbps() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Used to configure the matching criteria of a network characteristic. This may include network
 * capabilities, or cellular subscription information. Denotes that networks with or without the
 * characteristic are both acceptable to match this template.
 */

public static final int MATCH_ANY = 0; // 0x0

/**
 * Used to configure the matching criteria of a network characteristic. This may include network
 * capabilities, or cellular subscription information. Denotes that a network MUST NOT have the
 * capability in order to match this template.
 */

public static final int MATCH_FORBIDDEN = 2; // 0x2

/**
 * Used to configure the matching criteria of a network characteristic. This may include network
 * capabilities, or cellular subscription information. Denotes that a network MUST have the
 * capability in order to match this template.
 */

public static final int MATCH_REQUIRED = 1; // 0x1
}

