/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.vcn;

import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import java.util.Set;

/**
 * This class represents a configuration for a Virtual Carrier Network.
 *
 * <p>Each {@link android.net.vcn.VcnGatewayConnectionConfig VcnGatewayConnectionConfig} instance added represents a connection that will be
 * brought up on demand based on active {@link android.net.NetworkRequest NetworkRequest}(s).
 *
 * @see android.net.vcn.VcnManager for more information on the Virtual Carrier Network feature
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class VcnConfig implements android.os.Parcelable {

VcnConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param other This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the set of configured GatewayConnection(s).
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<android.net.vcn.VcnGatewayConnectionConfig> getGatewayConnectionConfigs() { throw new RuntimeException("Stub!"); }

/**
 * Retrieve the transports that will be restricted by the VCN.
 *
 * @see android.net.vcn.VcnConfig.Builder#setRestrictedUnderlyingNetworkTransports(Set)

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.Integer> getRestrictedUnderlyingNetworkTransports() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param out This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.vcn.VcnConfig> CREATOR;
static { CREATOR = null; }
/** This class is used to incrementally build {@link android.net.vcn.VcnConfig VcnConfig} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param context This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * Adds a configuration for an individual gateway connection.
 *
 * @param gatewayConnectionConfig the configuration for an individual gateway connection
 * This value cannot be {@code null}.
 * @return this {@link android.net.vcn.VcnConfig.Builder Builder} instance, for chaining
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if a VcnGatewayConnectionConfig has already been set for
 *     this {@link android.net.vcn.VcnConfig VcnConfig} with the same GatewayConnection name (as returned via {@link android.net.vcn.VcnGatewayConnectionConfig#getGatewayConnectionName()      }).
 */

@android.annotation.NonNull
public android.net.vcn.VcnConfig.Builder addGatewayConnectionConfig(@android.annotation.NonNull android.net.vcn.VcnGatewayConnectionConfig gatewayConnectionConfig) { throw new RuntimeException("Stub!"); }

/**
 * Builds and validates the VcnConfig.
 *
 * @return an immutable VcnConfig instance

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Sets transports that will be restricted by the VCN.
 *
 * <p>In general, apps will not be able to bind to, or use a restricted network. In other
 * words, unless the network type is marked restricted, any app can opt to use underlying
 * networks, instead of through the VCN.
 *
 * @param transports transports that will be restricted by VCN. Networks that include any of
 *     the transports will be marked as restricted. {@link android.net.NetworkCapabilities#TRANSPORT_WIFI      } is marked restricted by default.
 * This value cannot be {@code null}.
 * @return this {@link android.net.vcn.VcnConfig.Builder Builder} instance, for chaining
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the input contains unsupported transport types.
 * @see android.net.NetworkCapabilities#NET_CAPABILITY_NOT_RESTRICTED
 */

@android.annotation.NonNull
public android.net.vcn.VcnConfig.Builder setRestrictedUnderlyingNetworkTransports(@android.annotation.NonNull java.util.Set<java.lang.Integer> transports) { throw new RuntimeException("Stub!"); }
}

}

