/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;

import android.net.eap.EapInfo;

/**
 * IkeSessionConfiguration represents the negotiated configuration for a {@link android.net.ipsec.ike.IkeSession IkeSession}.
 *
 * <p>Configurations include remote application version and enabled IKE extensions.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IkeSessionConfiguration {

IkeSessionConfiguration() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the EAP information.
 *
 * @return the EAP information provided by the server during EAP authentication (e.g. next
 *    re-authentication ID), or null if the server did not provide any information that will be
 *    useful after the authentication.
 */

@android.annotation.Nullable
public android.net.eap.EapInfo getEapInfo() { throw new RuntimeException("Stub!"); }

/**
 * Returns the connection information.
 *
 * @return the IKE Session connection information.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionConnectionInfo getIkeSessionConnectionInfo() { throw new RuntimeException("Stub!"); }

/**
 * Gets remote (server) version information.
 *
 * @return application version of the remote server, or an empty string if the remote server did
 *     not provide the application version.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getRemoteApplicationVersion() { throw new RuntimeException("Stub!"); }

/**
 * Returns remote vendor IDs received during IKE Session setup.
 *
 * <p>According to the IKEv2 specification (RFC 7296), a vendor ID may indicate the sender is
 * capable of accepting certain extensions to the protocol, or it may simply identify the
 * implementation as an aid in debugging.
 *
 * @return the vendor IDs of the remote server, or an empty list if no vendor ID is received
 *     during IKE Session setup.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<byte[]> getRemoteVendorIds() { throw new RuntimeException("Stub!"); }

/**
 * Checks if an IKE extension is enabled.
 *
 * <p>An IKE extension is enabled when both sides can support it. This negotiation always
 * happens in IKE initial exchanges (IKE INIT and IKE AUTH).
 *
 * @param extensionType the extension type.
 * Value is {@link android.net.ipsec.ike.IkeSessionConfiguration#EXTENSION_TYPE_FRAGMENTATION}, or {@link android.net.ipsec.ike.IkeSessionConfiguration#EXTENSION_TYPE_MOBIKE}
 * @return {@code true} if this extension is enabled.
 */

public boolean isIkeExtensionEnabled(int extensionType) { throw new RuntimeException("Stub!"); }

/** IKE Message Fragmentation */

public static final int EXTENSION_TYPE_FRAGMENTATION = 1; // 0x1

/** IKEv2 Mobility and Multihoming Protocol */

public static final int EXTENSION_TYPE_MOBIKE = 2; // 0x2
/**
 * This class can be used to incrementally construct a {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration}.
 *
 * <p>Except for testing, IKE library users normally do not instantiate {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration} themselves but instead get a reference via {@link android.net.ipsec.ike.IkeSessionCallback IkeSessionCallback}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a Builder.
 *
 * @param ikeConnInfo the connection information

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.ipsec.ike.IkeSessionConnectionInfo ikeConnInfo) { throw new RuntimeException("Stub!"); }

/**
 * Marks an IKE extension as enabled for the {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration} being built.
 *
 * @param extensionType the enabled extension
 * Value is {@link android.net.ipsec.ike.IkeSessionConfiguration#EXTENSION_TYPE_FRAGMENTATION}, or {@link android.net.ipsec.ike.IkeSessionConfiguration#EXTENSION_TYPE_MOBIKE}
 * @return Builder this, to facilitate chaining
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionConfiguration.Builder addIkeExtension(int extensionType) { throw new RuntimeException("Stub!"); }

/**
 * Adds a remote vendor ID for the {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration} being built.
 *
 * @param remoteVendorId a remote vendor ID
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionConfiguration.Builder addRemoteVendorId(@android.annotation.NonNull byte[] remoteVendorId) { throw new RuntimeException("Stub!"); }

/**
 * Constructs an {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionConfiguration build() { throw new RuntimeException("Stub!"); }

/**
 * Clear all enabled IKE extensions from the {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration} being built.
 *
 * @return Builder this, to facilitate chaining

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionConfiguration.Builder clearIkeExtensions() { throw new RuntimeException("Stub!"); }

/**
 * Clears the remote application version from the {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration} being
 * built.
 *
 * @return Builder this, to facilitate chaining

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionConfiguration.Builder clearRemoteApplicationVersion() { throw new RuntimeException("Stub!"); }

/**
 * Clears all remote vendor IDs from the {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration} being built.
 *
 * @return Builder this, to facilitate chaining

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionConfiguration.Builder clearRemoteVendorIds() { throw new RuntimeException("Stub!"); }

/**
 * Sets EapInfo for the {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration} being built.
 *
 * @param eapInfo This value may be {@code null}.
 * @return Builder this, to facilitate chaining
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionConfiguration.Builder setEapInfo(@android.annotation.Nullable android.net.eap.EapInfo eapInfo) { throw new RuntimeException("Stub!"); }

/**
 * Sets the remote application version for the {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration} being built.
 *
 * @param remoteApplicationVersion the remote application version. Defaults to an empty
 *     string.
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionConfiguration.Builder setRemoteApplicationVersion(@android.annotation.NonNull java.lang.String remoteApplicationVersion) { throw new RuntimeException("Stub!"); }
}

}

