/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * IkeFqdnIdentification represents an IKE entity identification based on a fully-qualified domain
 * name (FQDN). An example might be ike.android.com
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class IkeFqdnIdentification extends android.net.ipsec.ike.IkeIdentification {

/**
 * Construct an instance of {@link android.net.ipsec.ike.IkeFqdnIdentification IkeFqdnIdentification} with a fully-qualified domain name.
 *
 * @param fqdn the fully-qualified domain name (FQDN).  Must contain only US-ASCII characters,
 * otherwise an IllegalArugmentException will be thrown.

 * This value cannot be {@code null}.
 */

public IkeFqdnIdentification(@android.annotation.NonNull java.lang.String fqdn) { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** The fully-qualified domain name(FQDN). */

@android.annotation.NonNull public final java.lang.String fqdn;
{ fqdn = null; }
}

