// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


package android.net.http;


/**
 * Basic information about a response. Included in {@link android.net.http.UrlRequest.Callback UrlRequest.Callback} callbacks. Each
 * {@link android.net.http.UrlRequest.Callback#onRedirectReceived onRedirectReceived()} callback gets a different
 * copy of {@code UrlResponseInfo} describing a particular redirect response.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class UrlResponseInfo {

public UrlResponseInfo() { throw new RuntimeException("Stub!"); }

/**
 * Returns the response headers.
 */

@android.annotation.NonNull
public abstract android.net.http.HeaderBlock getHeaders();

/**
 * Returns the HTTP status code. When a resource is retrieved from the cache, whether it was
 * revalidated or not, the original status code is returned.
 *
 * @return the HTTP status code.
 */

public abstract int getHttpStatusCode();

/**
 * Returns the HTTP status text of the status line. For example, if the request received a
 * "HTTP/1.1 200 OK" response, this method returns "OK".
 *
 * @return the HTTP status text of the status line.
 */

@android.annotation.NonNull
public abstract java.lang.String getHttpStatusText();

/**
 * Returns the protocol (for example 'quic/1+spdy/3') negotiated with the server. Returns an
 * empty string if no protocol was negotiated, the protocol is not known, or when using plain
 * HTTP or HTTPS.
 *
 * @return the protocol negotiated with the server.
 */

@android.annotation.NonNull
public abstract java.lang.String getNegotiatedProtocol();

/**
 * Returns a minimum count of bytes received from the network to process this request. This
 * count may ignore certain overheads (for example IP and TCP/UDP framing, SSL handshake and
 * framing, proxy handling). This count is taken prior to decompression (for example GZIP) and
 * includes headers and data from all redirects.
 *
 * This value may change (even for one {@link android.net.http.UrlResponseInfo UrlResponseInfo} instance) as the request
 * progresses until completion, when {@link android.net.http.UrlRequest.Callback#onSucceeded onSucceeded()},
 * {@link android.net.http.UrlRequest.Callback#onFailed onFailed()}, or {@link android.net.http.UrlRequest.Callback#onCanceled  onCanceled()} is called.
 *
 * @return a minimum count of bytes received from the network to process this request.
 */

public abstract long getReceivedByteCount();

/**
 * Returns the URL the response is for. This is the URL after following redirects, so it may not
 * be the originally requested URL.
 *
 * @return the URL the response is for.
 */

@android.annotation.NonNull
public abstract java.lang.String getUrl();

/**
 * Returns the URL chain. The first entry is the originally requested URL; the following entries
 * are redirects followed.
 *
 * @return the URL chain.
 */

@android.annotation.NonNull
public abstract java.util.List<java.lang.String> getUrlChain();

/**
 * Returns {@code true} if the response came from the cache, including requests that were
 * revalidated over the network before being retrieved from the cache.
 *
 * @return {@code true} if the response came from the cache, {@code false} otherwise.
 */

public abstract boolean wasCached();
}

