/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.eap;

import android.net.ipsec.ike.IkeSessionConfiguration;

/**
 * EapAkaInfo represents data provided by the server during EAP AKA authentication
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class EapAkaInfo extends android.net.eap.EapInfo {

EapAkaInfo() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves re-authentication ID from server for next use.
 *
 * @return re-authentication ID
 *
 * This value may be {@code null}.
 * @see <a href="https://datatracker.ietf.org/doc/html/rfc4187#section-5">RFC 4186,
 *     Extensible Authentication Protocol Method for 3rd Generation Authentication and
 *     Key Agreement (EAP-AKA)</a>
 */

@android.annotation.Nullable
public byte[] getReauthId() { throw new RuntimeException("Stub!"); }
/**
 * This class can be used to incrementally construct an {@link android.net.eap.EapAkaInfo EapAkaInfo}.
 *
 * <p>Except for testing, IKE library users normally do not instantiate {@link android.net.eap.EapAkaInfo EapAkaInfo}
 * themselves but instead get a reference via {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Constructs and returns an EapAkaInfo with the information applied to this
 * Builder.
 *
 * @return the EapAkaInfo constructed by this Builder.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapAkaInfo build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the re-authentication ID for next use.
 *
 * @param reauthId byte[] representing the client's EAP Identity.
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapAkaInfo.Builder setReauthId(@android.annotation.NonNull byte[] reauthId) { throw new RuntimeException("Stub!"); }
}

}

