/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.tv.ad;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TvAdManager {

TvAdManager() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.tv.ad.TvAdServiceInfo> getTvAdServiceList() { throw new RuntimeException("Stub!"); }

public void registerCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.tv.ad.TvAdManager.TvAdServiceCallback callback) { throw new RuntimeException("Stub!"); }

public void sendAppLinkCommand(@android.annotation.NonNull java.lang.String serviceId, @android.annotation.NonNull android.os.Bundle command) { throw new RuntimeException("Stub!"); }

public void unregisterCallback(@android.annotation.NonNull android.media.tv.ad.TvAdManager.TvAdServiceCallback callback) { throw new RuntimeException("Stub!"); }

public static final java.lang.String ACTION_APP_LINK_COMMAND = "android.media.tv.ad.action.APP_LINK_COMMAND";

public static final java.lang.String APP_LINK_KEY_BACK_URI = "back_uri";

public static final java.lang.String APP_LINK_KEY_CLASS_NAME = "class_name";

public static final java.lang.String APP_LINK_KEY_COMMAND_TYPE = "command_type";

public static final java.lang.String APP_LINK_KEY_PACKAGE_NAME = "package_name";

public static final java.lang.String APP_LINK_KEY_SERVICE_ID = "service_id";

public static final int ERROR_BLOCKED = 5; // 0x5

public static final int ERROR_ENCRYPTED = 6; // 0x6

public static final int ERROR_NONE = 0; // 0x0

public static final int ERROR_NOT_SUPPORTED = 2; // 0x2

public static final int ERROR_RESOURCE_UNAVAILABLE = 4; // 0x4

public static final int ERROR_UNKNOWN = 1; // 0x1

public static final int ERROR_UNKNOWN_CHANNEL = 7; // 0x7

public static final int ERROR_WEAK_SIGNAL = 3; // 0x3

public static final java.lang.String INTENT_KEY_AD_SERVICE_ID = "ad_service_id";

public static final java.lang.String INTENT_KEY_CHANNEL_URI = "channel_uri";

public static final java.lang.String INTENT_KEY_COMMAND_TYPE = "command_type";

public static final java.lang.String INTENT_KEY_TV_INPUT_ID = "tv_input_id";

public static final java.lang.String SESSION_DATA_KEY_AD_BUFFER = "ad_buffer";

public static final java.lang.String SESSION_DATA_KEY_AD_REQUEST = "ad_request";

public static final java.lang.String SESSION_DATA_KEY_BROADCAST_INFO_REQUEST = "broadcast_info_request";

public static final java.lang.String SESSION_DATA_KEY_REQUEST_ID = "request_id";

public static final java.lang.String SESSION_DATA_TYPE_AD_BUFFER_READY = "ad_buffer_ready";

public static final java.lang.String SESSION_DATA_TYPE_AD_REQUEST = "ad_request";

public static final java.lang.String SESSION_DATA_TYPE_BROADCAST_INFO_REQUEST = "broadcast_info_request";

public static final java.lang.String SESSION_DATA_TYPE_REMOVE_BROADCAST_INFO_REQUEST = "remove_broadcast_info_request";

public static final int SESSION_STATE_ERROR = 3; // 0x3

public static final int SESSION_STATE_RUNNING = 2; // 0x2

public static final int SESSION_STATE_STOPPED = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class TvAdServiceCallback {

public TvAdServiceCallback() { throw new RuntimeException("Stub!"); }

public void onAdServiceAdded(@android.annotation.NonNull java.lang.String serviceId) { throw new RuntimeException("Stub!"); }

public void onAdServiceRemoved(@android.annotation.NonNull java.lang.String serviceId) { throw new RuntimeException("Stub!"); }

public void onAdServiceUpdated(@android.annotation.NonNull java.lang.String serviceId) { throw new RuntimeException("Stub!"); }
}

}

