/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.session;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaSessionManager {

MediaSessionManager() { throw new RuntimeException("Stub!"); }

public void addOnActiveSessionsChangedListener(@android.annotation.NonNull android.media.session.MediaSessionManager.OnActiveSessionsChangedListener sessionListener, @android.annotation.Nullable android.content.ComponentName notificationListener) { throw new RuntimeException("Stub!"); }

public void addOnActiveSessionsChangedListener(@android.annotation.NonNull android.media.session.MediaSessionManager.OnActiveSessionsChangedListener sessionListener, @android.annotation.Nullable android.content.ComponentName notificationListener, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void addOnMediaKeyEventSessionChangedListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.session.MediaSessionManager.OnMediaKeyEventSessionChangedListener listener) { throw new RuntimeException("Stub!"); }

public void addOnSession2TokensChangedListener(@android.annotation.NonNull android.media.session.MediaSessionManager.OnSession2TokensChangedListener listener) { throw new RuntimeException("Stub!"); }

public void addOnSession2TokensChangedListener(@android.annotation.NonNull android.media.session.MediaSessionManager.OnSession2TokensChangedListener listener, @android.annotation.NonNull android.os.Handler handler) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.session.MediaController> getActiveSessions(@android.annotation.Nullable android.content.ComponentName notificationListener) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.session.MediaSession.Token getMediaKeyEventSession() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getMediaKeyEventSessionPackageName() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.Session2Token> getSession2Tokens() { throw new RuntimeException("Stub!"); }

public boolean isTrustedForMediaControl(@android.annotation.NonNull android.media.session.MediaSessionManager.RemoteUserInfo userInfo) { throw new RuntimeException("Stub!"); }

@Deprecated
public void notifySession2Created(@android.annotation.NonNull android.media.Session2Token token) { throw new RuntimeException("Stub!"); }

public void removeOnActiveSessionsChangedListener(@android.annotation.NonNull android.media.session.MediaSessionManager.OnActiveSessionsChangedListener sessionListener) { throw new RuntimeException("Stub!"); }

public void removeOnMediaKeyEventSessionChangedListener(@android.annotation.NonNull android.media.session.MediaSessionManager.OnMediaKeyEventSessionChangedListener listener) { throw new RuntimeException("Stub!"); }

public void removeOnSession2TokensChangedListener(@android.annotation.NonNull android.media.session.MediaSessionManager.OnSession2TokensChangedListener listener) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnActiveSessionsChangedListener {

public void onActiveSessionsChanged(@android.annotation.Nullable java.util.List<android.media.session.MediaController> controllers);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnMediaKeyEventSessionChangedListener {

public void onMediaKeyEventSessionChanged(@android.annotation.NonNull java.lang.String packageName, @android.annotation.Nullable android.media.session.MediaSession.Token sessionToken);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnSession2TokensChangedListener {

public void onSession2TokensChanged(@android.annotation.NonNull java.util.List<android.media.Session2Token> tokens);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class RemoteUserInfo {

public RemoteUserInfo(@android.annotation.NonNull java.lang.String packageName, int pid, int uid) { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

public int getPid() { throw new RuntimeException("Stub!"); }

public int getUid() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

}

