/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RouteListingPreference implements android.os.Parcelable {

RouteListingPreference() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object other) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.RouteListingPreference.Item> getItems() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.ComponentName getLinkedItemComponentName() { throw new RuntimeException("Stub!"); }

public boolean getUseSystemOrdering() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final java.lang.String ACTION_TRANSFER_MEDIA = "android.media.action.TRANSFER_MEDIA";

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.RouteListingPreference> CREATOR;
static { CREATOR = null; }

public static final java.lang.String EXTRA_ROUTE_ID = "android.media.extra.ROUTE_ID";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.RouteListingPreference build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.RouteListingPreference.Builder setItems(@android.annotation.NonNull java.util.List<android.media.RouteListingPreference.Item> items) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.RouteListingPreference.Builder setLinkedItemComponentName(@android.annotation.Nullable android.content.ComponentName linkedItemComponentName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.RouteListingPreference.Builder setUseSystemOrdering(boolean useSystemOrdering) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Item implements android.os.Parcelable {

Item() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object other) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getCustomSubtextMessage() { throw new RuntimeException("Stub!"); }

public int getFlags() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getRouteId() { throw new RuntimeException("Stub!"); }

public int getSelectionBehavior() { throw new RuntimeException("Stub!"); }

public int getSubText() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.RouteListingPreference.Item> CREATOR;
static { CREATOR = null; }

public static final int FLAG_ONGOING_SESSION = 1; // 0x1

public static final int FLAG_ONGOING_SESSION_MANAGED = 2; // 0x2

public static final int FLAG_SUGGESTED = 4; // 0x4

public static final int SELECTION_BEHAVIOR_GO_TO_APP = 2; // 0x2

public static final int SELECTION_BEHAVIOR_NONE = 0; // 0x0

public static final int SELECTION_BEHAVIOR_TRANSFER = 1; // 0x1

public static final int SUBTEXT_AD_ROUTING_DISALLOWED = 4; // 0x4

public static final int SUBTEXT_CUSTOM = 10000; // 0x2710

public static final int SUBTEXT_DEVICE_LOW_POWER = 5; // 0x5

public static final int SUBTEXT_DOWNLOADED_CONTENT_ROUTING_DISALLOWED = 3; // 0x3

public static final int SUBTEXT_ERROR_UNKNOWN = 1; // 0x1

public static final int SUBTEXT_NONE = 0; // 0x0

public static final int SUBTEXT_SUBSCRIPTION_REQUIRED = 2; // 0x2

public static final int SUBTEXT_TRACK_UNSUPPORTED = 7; // 0x7

public static final int SUBTEXT_UNAUTHORIZED = 6; // 0x6
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull java.lang.String routeId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.RouteListingPreference.Item build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.RouteListingPreference.Item.Builder setCustomSubtextMessage(@android.annotation.Nullable java.lang.CharSequence customSubtextMessage) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.RouteListingPreference.Item.Builder setFlags(int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.RouteListingPreference.Item.Builder setSelectionBehavior(int selectionBehavior) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.RouteListingPreference.Item.Builder setSubText(int subText) { throw new RuntimeException("Stub!"); }
}

}

}

