/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AudioRecord implements android.media.AudioRecordingMonitor, android.media.AudioRouting, android.media.MicrophoneDirection {

public AudioRecord(int audioSource, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes) throws java.lang.IllegalArgumentException { throw new RuntimeException("Stub!"); }

@Deprecated
public void addOnRoutingChangedListener(android.media.AudioRecord.OnRoutingChangedListener listener, android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void addOnRoutingChangedListener(android.media.AudioRouting.OnRoutingChangedListener listener, android.os.Handler handler) { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

public java.util.List<android.media.MicrophoneInfo> getActiveMicrophones() throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.AudioRecordingConfiguration getActiveRecordingConfiguration() { throw new RuntimeException("Stub!"); }

public int getAudioFormat() { throw new RuntimeException("Stub!"); }

public int getAudioSessionId() { throw new RuntimeException("Stub!"); }

public int getAudioSource() { throw new RuntimeException("Stub!"); }

public int getBufferSizeInFrames() { throw new RuntimeException("Stub!"); }

public int getChannelConfiguration() { throw new RuntimeException("Stub!"); }

public int getChannelCount() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioFormat getFormat() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.LogSessionId getLogSessionId() { throw new RuntimeException("Stub!"); }

public android.os.PersistableBundle getMetrics() { throw new RuntimeException("Stub!"); }

public static int getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) { throw new RuntimeException("Stub!"); }

public int getNotificationMarkerPosition() { throw new RuntimeException("Stub!"); }

public int getPositionNotificationPeriod() { throw new RuntimeException("Stub!"); }

public android.media.AudioDeviceInfo getPreferredDevice() { throw new RuntimeException("Stub!"); }

public int getRecordingState() { throw new RuntimeException("Stub!"); }

public android.media.AudioDeviceInfo getRoutedDevice() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.media.AudioDeviceInfo> getRoutedDevices() { throw new RuntimeException("Stub!"); }

public int getSampleRate() { throw new RuntimeException("Stub!"); }

public int getState() { throw new RuntimeException("Stub!"); }

public int getTimestamp(@android.annotation.NonNull android.media.AudioTimestamp outTimestamp, int timebase) { throw new RuntimeException("Stub!"); }

public boolean isPrivacySensitive() { throw new RuntimeException("Stub!"); }

public int read(@android.annotation.NonNull byte[] audioData, int offsetInBytes, int sizeInBytes) { throw new RuntimeException("Stub!"); }

public int read(@android.annotation.NonNull byte[] audioData, int offsetInBytes, int sizeInBytes, int readMode) { throw new RuntimeException("Stub!"); }

public int read(@android.annotation.NonNull float[] audioData, int offsetInFloats, int sizeInFloats, int readMode) { throw new RuntimeException("Stub!"); }

public int read(@android.annotation.NonNull java.nio.ByteBuffer audioBuffer, int sizeInBytes) { throw new RuntimeException("Stub!"); }

public int read(@android.annotation.NonNull java.nio.ByteBuffer audioBuffer, int sizeInBytes, int readMode) { throw new RuntimeException("Stub!"); }

public int read(@android.annotation.NonNull short[] audioData, int offsetInShorts, int sizeInShorts) { throw new RuntimeException("Stub!"); }

public int read(@android.annotation.NonNull short[] audioData, int offsetInShorts, int sizeInShorts, int readMode) { throw new RuntimeException("Stub!"); }

public void registerAudioRecordingCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.AudioManager.AudioRecordingCallback cb) { throw new RuntimeException("Stub!"); }

public void release() { throw new RuntimeException("Stub!"); }

@Deprecated
public void removeOnRoutingChangedListener(android.media.AudioRecord.OnRoutingChangedListener listener) { throw new RuntimeException("Stub!"); }

public void removeOnRoutingChangedListener(android.media.AudioRouting.OnRoutingChangedListener listener) { throw new RuntimeException("Stub!"); }

public void setLogSessionId(@android.annotation.NonNull android.media.metrics.LogSessionId logSessionId) { throw new RuntimeException("Stub!"); }

public int setNotificationMarkerPosition(int markerInFrames) { throw new RuntimeException("Stub!"); }

public int setPositionNotificationPeriod(int periodInFrames) { throw new RuntimeException("Stub!"); }

public boolean setPreferredDevice(android.media.AudioDeviceInfo deviceInfo) { throw new RuntimeException("Stub!"); }

public boolean setPreferredMicrophoneDirection(int direction) { throw new RuntimeException("Stub!"); }

public boolean setPreferredMicrophoneFieldDimension(float zoom) { throw new RuntimeException("Stub!"); }

public void setRecordPositionUpdateListener(android.media.AudioRecord.OnRecordPositionUpdateListener listener) { throw new RuntimeException("Stub!"); }

public void setRecordPositionUpdateListener(android.media.AudioRecord.OnRecordPositionUpdateListener listener, android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void startRecording() throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void startRecording(android.media.MediaSyncEvent syncEvent) throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void stop() throws java.lang.IllegalStateException { throw new RuntimeException("Stub!"); }

public void unregisterAudioRecordingCallback(@android.annotation.NonNull android.media.AudioManager.AudioRecordingCallback cb) { throw new RuntimeException("Stub!"); }

public static final int ERROR = -1; // 0xffffffff

public static final int ERROR_BAD_VALUE = -2; // 0xfffffffe

public static final int ERROR_DEAD_OBJECT = -6; // 0xfffffffa

public static final int ERROR_INVALID_OPERATION = -3; // 0xfffffffd

public static final int READ_BLOCKING = 0; // 0x0

public static final int READ_NON_BLOCKING = 1; // 0x1

public static final int RECORDSTATE_RECORDING = 3; // 0x3

public static final int RECORDSTATE_STOPPED = 1; // 0x1

public static final int STATE_INITIALIZED = 1; // 0x1

public static final int STATE_UNINITIALIZED = 0; // 0x0

public static final int SUCCESS = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public android.media.AudioRecord build() throws java.lang.UnsupportedOperationException { throw new RuntimeException("Stub!"); }

public android.media.AudioRecord.Builder setAudioFormat(@android.annotation.NonNull android.media.AudioFormat format) throws java.lang.IllegalArgumentException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioRecord.Builder setAudioPlaybackCaptureConfig(@android.annotation.NonNull android.media.AudioPlaybackCaptureConfiguration config) { throw new RuntimeException("Stub!"); }

public android.media.AudioRecord.Builder setAudioSource(int source) throws java.lang.IllegalArgumentException { throw new RuntimeException("Stub!"); }

public android.media.AudioRecord.Builder setBufferSizeInBytes(int bufferSizeInBytes) throws java.lang.IllegalArgumentException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioRecord.Builder setContext(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.AudioRecord.Builder setPrivacySensitive(boolean privacySensitive) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class MetricsConstants {

MetricsConstants() { throw new RuntimeException("Stub!"); }

public static final java.lang.String CHANNELS = "android.media.audiorecord.channels";

public static final java.lang.String ENCODING = "android.media.audiorecord.encoding";

@Deprecated public static final java.lang.String LATENCY = "android.media.audiorecord.latency";

public static final java.lang.String SAMPLERATE = "android.media.audiorecord.samplerate";

public static final java.lang.String SOURCE = "android.media.audiorecord.source";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnRecordPositionUpdateListener {

public void onMarkerReached(android.media.AudioRecord recorder);

public void onPeriodicNotification(android.media.AudioRecord recorder);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static interface OnRoutingChangedListener extends android.media.AudioRouting.OnRoutingChangedListener {

@Deprecated
public void onRoutingChanged(android.media.AudioRecord audioRecord);

@Deprecated
public default void onRoutingChanged(android.media.AudioRouting router) { throw new RuntimeException("Stub!"); }
}

}

