/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;


/**
 * An encapsulation of various parameters for requesting location via {@link android.location.LocationManager LocationManager}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class LocationRequest implements android.os.Parcelable {

LocationRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the duration for which location will be provided before the request is automatically
 * removed. A duration of <code>Long.MAX_VALUE</code> represents an unlimited duration.
 *
 * @return the duration for which location will be provided

 * Value is 1 or greater
 */

public long getDurationMillis() { throw new RuntimeException("Stub!"); }

/**
 * Returns the desired interval of location updates, or {@link #PASSIVE_INTERVAL} if this is a
 * passive, no power request. A passive request will not actively generate location updates
 * (and thus will not be power blamed for location), but may receive location updates generated
 * as a result of other location requests. A passive request must always have an explicit
 * minimum update interval set.
 *
 * <p>Locations may be available at a faster interval than specified here, see
 * {@link #getMinUpdateIntervalMillis()} for the behavior in that case.
 *
 * @return the desired interval of location updates

 * Value is 0 or greater
 */

public long getIntervalMillis() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum time any location update may be delayed, and thus grouped with following
 * updates to enable location batching. If the maximum update delay is equal to or greater than
 * twice the interval, then location providers may provide batched results. The maximum batch
 * size is the maximum update delay divided by the interval. Not all devices or location
 * providers support batching, and use of this parameter does not guarantee that the client will
 * see batched results, or that batched results will always be of the maximum size.
 *
 * When available, batching can provide substantial power savings to the device, and clients are
 * encouraged to take advantage where appropriate for the use case.
 *
 * @see android.location.LocationListener#onLocationChanged(java.util.List)
 * @return the maximum time by which a location update may be delayed

 * Value is 0 or greater
 */

public long getMaxUpdateDelayMillis() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum number of location updates for this request before the request is
 * automatically removed. A max updates value of <code>Integer.MAX_VALUE</code> represents an
 * unlimited number of updates.

 * @return Value is between 1 and Integer.MAX_VALUE inclusive
 */

public int getMaxUpdates() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum distance between location updates. If a potential location update is
 * closer to the last location update than the minimum update distance, then the potential
 * location update will not occur. A value of 0 meters implies that no location update will ever
 * be rejected due to failing this constraint.
 *
 * @return the minimum distance between location updates

 * Value is between 0 and Float.MAX_VALUE inclusive
 */

public float getMinUpdateDistanceMeters() { throw new RuntimeException("Stub!"); }

/**
 * Returns the minimum update interval. If location updates are available faster than the
 * request interval then locations will only be updated if the minimum update interval has
 * expired since the last location update.
 *
 * <p class=note><strong>Note:</strong> Some allowance for jitter is already built into the
 * minimum update interval, so you need not worry about updates blocked simply because they
 * arrived a fraction of a second earlier than expected.
 *
 * @return the minimum update interval

 * Value is 0 or greater
 */

public long getMinUpdateIntervalMillis() { throw new RuntimeException("Stub!"); }

/**
 * Returns the quality hint for this location request. The quality hint informs the provider how
 * it should attempt to manage any accuracy vs power tradeoffs while attempting to satisfy this
 * location request.
 *
 * @return the desired quality tradeoffs between accuracy and power

 * Value is {@link android.location.LocationRequest#QUALITY_LOW_POWER}, {@link android.location.LocationRequest#QUALITY_BALANCED_POWER_ACCURACY}, or {@link android.location.LocationRequest#QUALITY_HIGH_ACCURACY}
 */

public int getQuality() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param parcel This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.LocationRequest> CREATOR;
static { CREATOR = null; }

/**
 * Represents a passive only request. Such a request will not trigger any active locations or
 * power usage itself, but may receive locations generated in response to other requests.
 *
 * @see android.location.LocationRequest#getIntervalMillis()
 */

public static final long PASSIVE_INTERVAL = 9223372036854775807L; // 0x7fffffffffffffffL

/**
 * A quality constant indicating a location provider may choose to satisfy this request by
 * equally balancing power and accuracy constraints. Each location provider may interpret this
 * field differently, but location providers will generally use their default behavior when this
 * flag is present.
 */

public static final int QUALITY_BALANCED_POWER_ACCURACY = 102; // 0x66

/**
 * A quality constant indicating a location provider may choose to satisfy this request by
 * providing very accurate locations at the expense of potentially increased power usage. Each
 * location provider may interpret this field differently, but as an example, the network
 * provider may choose to return only wifi based locations rather than cell based locations in
 * order to have greater accuracy when this flag is present.
 */

public static final int QUALITY_HIGH_ACCURACY = 100; // 0x64

/**
 * A quality constant indicating a location provider may choose to satisfy this request by
 * providing less accurate locations in order to save power. Each location provider may
 * interpret this field differently, but as an example, the network provider may choose to
 * return cell based locations rather than wifi based locations in order to save power when this
 * flag is present.
 */

public static final int QUALITY_LOW_POWER = 104; // 0x68
/**
 * A builder class for {@link android.location.LocationRequest LocationRequest}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new Builder with all parameters copied from the given location request.

 * @param locationRequest This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.location.LocationRequest locationRequest) { throw new RuntimeException("Stub!"); }

/**
 * Creates a new Builder with the given interval. See {@link #setIntervalMillis(long)} for
 * more information on the interval.
 */

public Builder(long intervalMillis) { throw new RuntimeException("Stub!"); }

/**
 * Builds a location request from this builder. If an explicit minimum update interval is
 * set, the minimum update interval of the location request will be the minimum of the
 * interval and minimum update interval.
 *
 * <p>If building a passive request then you must have set an explicit minimum update
 * interval.
 *
 * @throws java.lang.IllegalStateException if building a passive request with no explicit minimum
 * update interval set
 * @return a new location request

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.LocationRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Clears an explicitly set minimum update interval and reverts to an implicit minimum
 * update interval (ie, the minimum update interval is some sensible default between 0 and
 * the interval).

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.LocationRequest.Builder clearMinUpdateIntervalMillis() { throw new RuntimeException("Stub!"); }

/**
 * Sets the duration this request will continue before being automatically removed. Defaults
 * to <code>Long.MAX_VALUE</code>, which represents an unlimited duration.
 
 * @param durationMillis Value is 1 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.LocationRequest.Builder setDurationMillis(long durationMillis) { throw new RuntimeException("Stub!"); }

/**
 * Sets the request interval. The request interval may be set to {@link #PASSIVE_INTERVAL}
 * which indicates this request will not actively generate location updates (and thus will
 * not be power blamed for location), but may receive location updates generated as a result
 * of other location requests. A passive request must always have an explicit minimum
 * update interval set.
 *
 * <p>Locations may be available at a faster interval than specified here, see
 * {@link #setMinUpdateIntervalMillis(long)} for the behavior in that case.
 
 * @param intervalMillis Value is 0 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.LocationRequest.Builder setIntervalMillis(long intervalMillis) { throw new RuntimeException("Stub!"); }

/**
 * Sets the maximum time any location update may be delayed, and thus grouped with following
 * updates to enable location batching. If the maximum update delay is equal to or greater
 * than twice the interval, then location providers may provide batched results. Defaults to
 * 0, which represents no batching allowed.
 
 * @param maxUpdateDelayMillis Value is 0 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.LocationRequest.Builder setMaxUpdateDelayMillis(long maxUpdateDelayMillis) { throw new RuntimeException("Stub!"); }

/**
 * Sets the maximum number of location updates for this request before this request is
 * automatically removed. Defaults to <code>Integer.MAX_VALUE</code>, which represents an
 * unlimited number of updates.
 
 * @param maxUpdates Value is between 1 and Integer.MAX_VALUE inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.LocationRequest.Builder setMaxUpdates(int maxUpdates) { throw new RuntimeException("Stub!"); }

/**
 * Sets the minimum update distance between location updates. If a potential location
 * update is closer to the last location update than the minimum update distance, then
 * the potential location update will not occur. Defaults to 0, which represents no minimum
 * update distance.
 
 * @param minUpdateDistanceMeters Value is between 0 and Float.MAX_VALUE inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.LocationRequest.Builder setMinUpdateDistanceMeters(float minUpdateDistanceMeters) { throw new RuntimeException("Stub!"); }

/**
 * Sets an explicit minimum update interval. If location updates are available faster than
 * the request interval then an update will only occur if the minimum update interval has
 * expired since the last location update. Defaults to no explicit minimum update interval
 * set, which means some sensible default between 0 and the interval will be chosen. The
 * exact value is not specified at the moment. If an exact known value is required, clients
 * should set an explicit value themselves.
 *
 * <p class=note><strong>Note:</strong> Some allowance for jitter is already built into the
 * minimum update interval, so you need not worry about updates blocked simply because they
 * arrived a fraction of a second earlier than expected.
 *
 * <p class="note"><strong>Note:</strong> When {@link #build()} is invoked, the minimum of
 * the interval and the minimum update interval will be used as the minimum update interval
 * of the built request.
 
 * @param minUpdateIntervalMillis Value is 0 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.LocationRequest.Builder setMinUpdateIntervalMillis(long minUpdateIntervalMillis) { throw new RuntimeException("Stub!"); }

/**
 * Sets the request quality. The quality is a hint to providers on how they should weigh
 * power vs accuracy tradeoffs. High accuracy locations may cost more power to produce, and
 * lower accuracy locations may cost less power to produce. Defaults to
 * {@link #QUALITY_BALANCED_POWER_ACCURACY}.
 
 * @param quality Value is {@link android.location.LocationRequest#QUALITY_LOW_POWER}, {@link android.location.LocationRequest#QUALITY_BALANCED_POWER_ACCURACY}, or {@link android.location.LocationRequest#QUALITY_HIGH_ACCURACY}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.LocationRequest.Builder setQuality(int quality) { throw new RuntimeException("Stub!"); }
}

}

