/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;


/**
 * This class represents the current state of the GNSS engine and is used in conjunction with
 * {@link android.location.GnssStatus.Callback GnssStatus.Callback}.
 *
 * @see LocationManager#registerGnssStatusCallback
 * @see android.location.GnssStatus.Callback
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GnssStatus implements android.os.Parcelable {

GnssStatus() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the azimuth the satellite at the specified index.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1
 
 * Value is 0 or greater
 * @return Value is between 0 and 360 inclusive
 */

public float getAzimuthDegrees(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the baseband carrier-to-noise density of the satellite at the specified index in
 * dB-Hz.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1
 
 * Value is 0 or greater
 * @return Value is between 0 and 63 inclusive
 */

public float getBasebandCn0DbHz(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * Gets the carrier frequency of the signal tracked.
 *
 * <p>For example it can be the GPS central frequency for L1 = 1575.45 MHz, or L2 = 1227.60
 * MHz, L5 = 1176.45 MHz, varying GLO channels, etc.
 *
 * <p>The value is only available if {@link #hasCarrierFrequencyHz(int satelliteIndex)} is
 * {@code true}.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1
 
 * Value is 0 or greater
 * @return Value is 0 or greater
 */

public float getCarrierFrequencyHz(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the carrier-to-noise density at the antenna of the satellite at the specified index
 * in dB-Hz.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1
 
 * Value is 0 or greater
 * @return Value is between 0 and 63 inclusive
 */

public float getCn0DbHz(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the constellation type of the satellite at the specified index.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1
 
 * Value is 0 or greater
 * @return Value is {@link android.location.GnssStatus#CONSTELLATION_UNKNOWN}, {@link android.location.GnssStatus#CONSTELLATION_GPS}, {@link android.location.GnssStatus#CONSTELLATION_SBAS}, {@link android.location.GnssStatus#CONSTELLATION_GLONASS}, {@link android.location.GnssStatus#CONSTELLATION_QZSS}, {@link android.location.GnssStatus#CONSTELLATION_BEIDOU}, {@link android.location.GnssStatus#CONSTELLATION_GALILEO}, or {@link android.location.GnssStatus#CONSTELLATION_IRNSS}
 */

public int getConstellationType(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the elevation of the satellite at the specified index.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1
 
 * Value is 0 or greater
 * @return Value is between -90 and 90 inclusive
 */

public float getElevationDegrees(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * Gets the total number of satellites in satellite list.

 * @return Value is 0 or greater
 */

public int getSatelliteCount() { throw new RuntimeException("Stub!"); }

/**
 * Gets the identification number for the satellite at the specific index.
 *
 * <p>This svid is pseudo-random number for most constellations. It is FCN &amp; OSN number for
 * Glonass.
 *
 * <p>The distinction is made by looking at constellation field
 * {@link #getConstellationType(int)} Expected values are in the range of:
 *
 * <ul>
 * <li>GPS: 1-32</li>
 * <li>SBAS: 120-151, 183-192</li>
 * <li>GLONASS: One of: OSN, or FCN+100
 * <ul>
 * <li>1-25 as the orbital slot number (OSN) (preferred, if known)</li>
 * <li>93-106 as the frequency channel number (FCN) (-7 to +6) plus 100.
 * i.e. encode FCN of -7 as 93, 0 as 100, and +6 as 106</li>
 * </ul></li>
 * <li>QZSS: 183-206</li>
 * <li>Galileo: 1-36</li>
 * <li>Beidou: 1-63</li>
 * <li>IRNSS: 1-14</li>
 * </ul>
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1
 
 * Value is 0 or greater
 * @return Value is between 1 and 206 inclusive
 */

public int getSvid(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * Reports whether the satellite at the specified index has almanac data.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1

 * Value is 0 or greater
 */

public boolean hasAlmanacData(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * Reports whether a valid {@link #getBasebandCn0DbHz(int satelliteIndex)} is available.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1

 * Value is 0 or greater
 */

public boolean hasBasebandCn0DbHz(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * Reports whether a valid {@link #getCarrierFrequencyHz(int satelliteIndex)} is available.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1

 * Value is 0 or greater
 */

public boolean hasCarrierFrequencyHz(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * Reports whether the satellite at the specified index has ephemeris data.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1

 * Value is 0 or greater
 */

public boolean hasEphemerisData(int satelliteIndex) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Reports whether the satellite at the specified index was used in the calculation of the most
 * recent position fix.
 *
 * @param satelliteIndex An index from zero to {@link #getSatelliteCount()} - 1

 * Value is 0 or greater
 */

public boolean usedInFix(int satelliteIndex) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param parcel This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

/** Constellation type constant for Beidou. */

public static final int CONSTELLATION_BEIDOU = 5; // 0x5

/** Constellation type constant for Galileo. */

public static final int CONSTELLATION_GALILEO = 6; // 0x6

/** Constellation type constant for Glonass. */

public static final int CONSTELLATION_GLONASS = 3; // 0x3

/** Constellation type constant for GPS. */

public static final int CONSTELLATION_GPS = 1; // 0x1

/** Constellation type constant for IRNSS. */

public static final int CONSTELLATION_IRNSS = 7; // 0x7

/** Constellation type constant for QZSS. */

public static final int CONSTELLATION_QZSS = 4; // 0x4

/** Constellation type constant for SBAS. */

public static final int CONSTELLATION_SBAS = 2; // 0x2

/** Unknown constellation type. */

public static final int CONSTELLATION_UNKNOWN = 0; // 0x0

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.GnssStatus> CREATOR;
static { CREATOR = null; }
/**
 * Builder class to help create new GnssStatus instances.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Adds a new satellite to the Builder.
 *
 * @param constellationType one of the CONSTELLATION_* constants
 * Value is {@link android.location.GnssStatus#CONSTELLATION_UNKNOWN}, {@link android.location.GnssStatus#CONSTELLATION_GPS}, {@link android.location.GnssStatus#CONSTELLATION_SBAS}, {@link android.location.GnssStatus#CONSTELLATION_GLONASS}, {@link android.location.GnssStatus#CONSTELLATION_QZSS}, {@link android.location.GnssStatus#CONSTELLATION_BEIDOU}, {@link android.location.GnssStatus#CONSTELLATION_GALILEO}, or {@link android.location.GnssStatus#CONSTELLATION_IRNSS}
 * @param svid the space vehicle identifier
 * Value is between 1 and 200 inclusive
 * @param cn0DbHz carrier-to-noise density at the antenna in dB-Hz
 * Value is between 0 and 63 inclusive
 * @param elevation satellite elevation in degrees
 * Value is between -90 and 90 inclusive
 * @param azimuth satellite azimuth in degrees
 * Value is between 0 and 360 inclusive
 * @param hasEphemeris whether the satellite has ephemeris data
 * @param hasAlmanac whether the satellite has almanac data
 * @param usedInFix whether the satellite was used in the most recent location fix
 * @param hasCarrierFrequency whether carrier frequency data is available
 * @param carrierFrequency satellite carrier frequency in Hz
 * Value is 0 or greater
 * @param hasBasebandCn0DbHz whether baseband carrier-to-noise density is available
 * @param basebandCn0DbHz baseband carrier-to-noise density in dB-Hz
 
 * Value is between 0 and 63 inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssStatus.Builder addSatellite(int constellationType, int svid, float cn0DbHz, float elevation, float azimuth, boolean hasEphemeris, boolean hasAlmanac, boolean usedInFix, boolean hasCarrierFrequency, float carrierFrequency, boolean hasBasebandCn0DbHz, float basebandCn0DbHz) { throw new RuntimeException("Stub!"); }

/**
 * Builds a new GnssStatus based on the satellite information in the Builder.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssStatus build() { throw new RuntimeException("Stub!"); }

/**
 * Clears all satellites in the Builder.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssStatus.Builder clearSatellites() { throw new RuntimeException("Stub!"); }
}

/**
 * Used for receiving notifications when GNSS events happen.
 *
 * @see LocationManager#registerGnssStatusCallback
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Callback {

public Callback() { throw new RuntimeException("Stub!"); }

/**
 * Called when the GNSS system has received its first fix since starting.
 *
 * @param ttffMillis the time from start to first fix in milliseconds.
 */

public void onFirstFix(int ttffMillis) { throw new RuntimeException("Stub!"); }

/**
 * Called periodically to report GNSS satellite status.
 *
 * @param status the current status of all satellites.

 * This value cannot be {@code null}.
 */

public void onSatelliteStatusChanged(@android.annotation.NonNull android.location.GnssStatus status) { throw new RuntimeException("Stub!"); }

/**
 * Called when GNSS system has started.
 */

public void onStarted() { throw new RuntimeException("Stub!"); }

/**
 * Called when GNSS system has stopped.
 */

public void onStopped() { throw new RuntimeException("Stub!"); }
}

}

