/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;


/**
 * A class that contains information about a GNSS antenna. GNSS antenna characteristics can change
 * with device configuration, such as when a device is folded open or closed. Antenna information is
 * delivered to registered instances of {@link android.location.GnssAntennaInfo.Listener Listener}.
 *
 * <p> Antenna info parameters are measured for each specific device model by the device
 * manufacturers and provided to the Android framework.
 *
 * <p> {@link android.location.GnssAntennaInfo GnssAntennaInfo} is returned per frequency band at the center frequency of the band.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GnssAntennaInfo implements android.os.Parcelable {

GnssAntennaInfo() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the center frequency of the corresponding carrier frequency band.
 * @return Value is 0.0f or greater
 */

public double getCarrierFrequencyMHz() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link android.location.GnssAntennaInfo.PhaseCenterOffset PhaseCenterOffset} object encapsulating the phase center offset and
 * corresponding uncertainties in millimeters.
 *
 * @return {@link android.location.GnssAntennaInfo.PhaseCenterOffset PhaseCenterOffset}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssAntennaInfo.PhaseCenterOffset getPhaseCenterOffset() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link android.location.GnssAntennaInfo.SphericalCorrections SphericalCorrections} object encapsulating the phase center variation
 * corrections and corresponding uncertainties in millimeters.
 *
 * @return phase center variation corrections as {@link android.location.GnssAntennaInfo.SphericalCorrections SphericalCorrections}

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.location.GnssAntennaInfo.SphericalCorrections getPhaseCenterVariationCorrections() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link android.location.GnssAntennaInfo.SphericalCorrections SphericalCorrections} object encapsulating the signal gain
 * corrections and corresponding uncertainties in dBi.
 *
 * @return signal gain corrections as {@link android.location.GnssAntennaInfo.SphericalCorrections SphericalCorrections}

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.location.GnssAntennaInfo.SphericalCorrections getSignalGainCorrections() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param parcel This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.GnssAntennaInfo> CREATOR;
static { CREATOR = null; }
/**
 * Builder class for GnssAntennaInfo.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

/**
 * @deprecated Prefer {@link #Builder(double,android.location.GnssAntennaInfo.PhaseCenterOffset)}.
 */

@Deprecated
public Builder() { throw new RuntimeException("Stub!"); }

/**
 * @param antennaInfo This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.location.GnssAntennaInfo antennaInfo) { throw new RuntimeException("Stub!"); }

/**
 * @param phaseCenterOffset This value cannot be {@code null}.
 */

public Builder(double carrierFrequencyMHz, @android.annotation.NonNull android.location.GnssAntennaInfo.PhaseCenterOffset phaseCenterOffset) { throw new RuntimeException("Stub!"); }

/**
 * Build GnssAntennaInfo object.
 *
 * @return instance of GnssAntennaInfo

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssAntennaInfo build() { throw new RuntimeException("Stub!"); }

/**
 * Set antenna carrier frequency (MHz).
 *
 * @param carrierFrequencyMHz antenna carrier frequency (MHz)
 * Value is 0.0f or greater
 * @return Builder builder object
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssAntennaInfo.Builder setCarrierFrequencyMHz(double carrierFrequencyMHz) { throw new RuntimeException("Stub!"); }

/**
 * Set antenna phase center offset.
 *
 * @param phaseCenterOffset phase center offset object
 * This value cannot be {@code null}.
 * @return Builder builder object
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssAntennaInfo.Builder setPhaseCenterOffset(@android.annotation.NonNull android.location.GnssAntennaInfo.PhaseCenterOffset phaseCenterOffset) { throw new RuntimeException("Stub!"); }

/**
 * Set phase center variation corrections.
 *
 * @param phaseCenterVariationCorrections phase center variation corrections object
 * This value may be {@code null}.
 * @return Builder builder object
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssAntennaInfo.Builder setPhaseCenterVariationCorrections(@android.annotation.Nullable android.location.GnssAntennaInfo.SphericalCorrections phaseCenterVariationCorrections) { throw new RuntimeException("Stub!"); }

/**
 * Set signal gain corrections.
 *
 * @param signalGainCorrections signal gain corrections object
 * This value may be {@code null}.
 * @return Builder builder object
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssAntennaInfo.Builder setSignalGainCorrections(@android.annotation.Nullable android.location.GnssAntennaInfo.SphericalCorrections signalGainCorrections) { throw new RuntimeException("Stub!"); }
}

/**
 * Used for receiving GNSS antenna info from the GNSS engine.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Listener {

/**
 * Invoked on a change to GNSS antenna info.

 * @param gnssAntennaInfos This value cannot be {@code null}.
 */

public void onGnssAntennaInfoReceived(@android.annotation.NonNull java.util.List<android.location.GnssAntennaInfo> gnssAntennaInfos);
}

/**
 * Class containing information about the antenna phase center offset (PCO). PCO is defined with
 * respect to the origin of the Android sensor coordinate system, e.g., center of primary screen
 * for mobiles - see sensor or form factor documents for details. Uncertainties are reported
 * to 1-sigma.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class PhaseCenterOffset implements android.os.Parcelable {

public PhaseCenterOffset(double offsetXMm, double offsetXUncertaintyMm, double offsetYMm, double offsetYUncertaintyMm, double offsetZMm, double offsetZUncertaintyMm) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the x-axis offset of the phase center from the origin of the Android sensor
 * coordinate system, in millimeters.
 */

public double getXOffsetMm() { throw new RuntimeException("Stub!"); }

/**
 * Returns the 1-sigma uncertainty of the x-axis offset of the phase center from the origin
 * of the Android sensor coordinate system, in millimeters.
 */

public double getXOffsetUncertaintyMm() { throw new RuntimeException("Stub!"); }

/**
 * Returns the y-axis offset of the phase center from the origin of the Android sensor
 * coordinate system, in millimeters.
 */

public double getYOffsetMm() { throw new RuntimeException("Stub!"); }

/**
 * Returns the 1-sigma uncertainty of the y-axis offset of the phase center from the origin
 * of the Android sensor coordinate system, in millimeters.
 */

public double getYOffsetUncertaintyMm() { throw new RuntimeException("Stub!"); }

/**
 * Returns the z-axis offset of the phase center from the origin of the Android sensor
 * coordinate system, in millimeters.
 */

public double getZOffsetMm() { throw new RuntimeException("Stub!"); }

/**
 * Returns the 1-sigma uncertainty of the z-axis offset of the phase center from the origin
 * of the Android sensor coordinate system, in millimeters.
 */

public double getZOffsetUncertaintyMm() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.GnssAntennaInfo.PhaseCenterOffset> CREATOR;
static { CREATOR = null; }
}

/**
 * Represents corrections on a spherical mapping. Corrections are added to measurements to
 * obtain the corrected values.
 *
 * The corrections and associated (1-sigma) uncertainties are represented by respect 2D arrays.
 *
 * Each row (major indices) represents a fixed theta. The first row corresponds to a
 * theta angle of 0 degrees. The last row corresponds to a theta angle of (360 - deltaTheta)
 * degrees, where deltaTheta is the regular spacing between azimuthal angles, i.e., deltaTheta
 * = 360 / (number of rows).
 *
 * The columns (minor indices) represent fixed zenith angles, beginning at 0 degrees and ending
 * at 180 degrees. They are separated by deltaPhi, the regular spacing between zenith angles,
 * i.e., deltaPhi = 180 / (number of columns - 1).
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class SphericalCorrections implements android.os.Parcelable {

/**
 * @param corrections This value cannot be {@code null}.

 * @param correctionUncertainties This value cannot be {@code null}.
 */

public SphericalCorrections(@android.annotation.NonNull double[][] corrections, @android.annotation.NonNull double[][] correctionUncertainties) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Array representing uncertainty on corrections on a spherical mapping.
 *
 * Each row (major indices) represents a fixed theta. The first row corresponds to a
 * theta angle of 0 degrees. The last row corresponds to a theta angle of (360 - deltaTheta)
 * degrees, where deltaTheta is the regular spacing between azimuthal angles, i.e.,
 * deltaTheta = 360 / (number of rows).
 *
 * The columns (minor indices) represent fixed zenith angles, beginning at 0 degrees and
 * ending at 180 degrees. They are separated by deltaPhi, the regular spacing between zenith
 * angles, i.e., deltaPhi = 180 / (number of columns - 1).

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public double[][] getCorrectionUncertaintiesArray() { throw new RuntimeException("Stub!"); }

/**
 * Array representing corrections on a spherical mapping. Corrections are added to
 * measurements to obtain the corrected values.
 *
 * Each row (major indices) represents a fixed theta. The first row corresponds to a
 * theta angle of 0 degrees. The last row corresponds to a theta angle of (360 - deltaTheta)
 * degrees, where deltaTheta is the regular spacing between azimuthal angles, i.e.,
 * deltaTheta = 360 / (number of rows).
 *
 * The columns (minor indices) represent fixed zenith angles, beginning at 0 degrees and
 * ending at 180 degrees. They are separated by deltaPhi, the regular spacing between zenith
 * angles, i.e., deltaPhi = 180 / (number of columns - 1).

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public double[][] getCorrectionsArray() { throw new RuntimeException("Stub!"); }

/**
 * The fixed phi angle separation between successive columns.

 * @return Value is between 0.0f and 180.0f inclusive
 */

public double getDeltaPhi() { throw new RuntimeException("Stub!"); }

/**
 * The fixed theta angle separation between successive rows.

 * @return Value is between 0.0f and 360.0f inclusive
 */

public double getDeltaTheta() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.GnssAntennaInfo.SphericalCorrections> CREATOR;
static { CREATOR = null; }
}

}

