/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes.units;


/** Represents a unit of length. Supported units: meters */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Length implements java.lang.Comparable<android.health.connect.datatypes.units.Length> {

Length() { throw new RuntimeException("Stub!"); }

/**
 * Compares this object with the specified object for order. Returns a negative integer, zero,
 * or a positive integer as this object is less than, equal to, or greater than the specified
 * object.
 *
 * @param other the object to be compared.
 * This value cannot be {@code null}.
 * @return a negative integer, zero, or a positive integer as this object is less than, equal
 *     to, or greater than the specified object.
 * @throws java.lang.NullPointerException if the specified object is null
 * @throws java.lang.ClassCastException if the specified object's type prevents it from being compared to
 *     this object.
 */

public int compareTo(@android.annotation.NonNull android.health.connect.datatypes.units.Length other) { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * @return {@code true} if this object is the same as the object argument; {@code false}
 *     otherwise.
 */

public boolean equals(java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * Creates a Length object with the specified value in meters.
 *
 * @param value value to be set as meters.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.health.connect.datatypes.units.Length fromMeters(double value) { throw new RuntimeException("Stub!"); }

/** Returns length in meters */

public double getInMeters() { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code value for the object.
 *
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * @return a string representation of the object.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

