/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;


/**
 * Captures a mindfulness session.
 *
 * <p>For example: yoga, meditation, guided breathing, etc.
 *
 * <p>Each record needs a start time, end time and a mindfulness session type. In addition, each
 * record has an optional title and notes.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MindfulnessSessionRecord extends android.health.connect.datatypes.IntervalRecord {

MindfulnessSessionRecord() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns type of the mindfulness session.
 * @return Value is {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_MEDITATION}, {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_OTHER}, {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_BREATHING}, {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_MUSIC}, {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_MOVEMENT}, or {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_UNGUIDED}
 */

public int getMindfulnessSessionType() { throw new RuntimeException("Stub!"); }

/** Returns notes for the mindfulness session. Returns null if no notes was specified. */

@android.annotation.Nullable
public java.lang.CharSequence getNotes() { throw new RuntimeException("Stub!"); }

/** Returns title of the mindfulness session. Returns null if no title was specified. */

@android.annotation.Nullable
public java.lang.CharSequence getTitle() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Metric identifier to retrieve total mindfulness session duration using aggregate APIs in
 * {@link android.health.connect.HealthConnectManager}. Calculated in milliseconds.
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> MINDFULNESS_DURATION_TOTAL;
static { MINDFULNESS_DURATION_TOTAL = null; }

/** Guided breathing mindfulness session. */

public static final int MINDFULNESS_SESSION_TYPE_BREATHING = 3; // 0x3

/** Meditation mindfulness session. */

public static final int MINDFULNESS_SESSION_TYPE_MEDITATION = 1; // 0x1

/** Stretches/movement mindfulness session. */

public static final int MINDFULNESS_SESSION_TYPE_MOVEMENT = 5; // 0x5

/** Music/soundscapes mindfulness session. */

public static final int MINDFULNESS_SESSION_TYPE_MUSIC = 4; // 0x4

/** Other mindfulness session. */

public static final int MINDFULNESS_SESSION_TYPE_OTHER = 2; // 0x2

/** Unguided mindfulness session. */

public static final int MINDFULNESS_SESSION_TYPE_UNGUIDED = 6; // 0x6

/** Use this type if the mindfulness session type is unknown. */

public static final int MINDFULNESS_SESSION_TYPE_UNKNOWN = 0; // 0x0
/** Builder class for {@link android.health.connect.datatypes.MindfulnessSessionRecord MindfulnessSessionRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param startTime Start time of this mindfulness session
 * This value cannot be {@code null}.
 * @param endTime End time of this mindfulness session
 
 * This value cannot be {@code null}.

 * @param mindfulnessSessionType Value is {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_MEDITATION}, {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_OTHER}, {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_BREATHING}, {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_MUSIC}, {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_MOVEMENT}, or {@link android.health.connect.datatypes.MindfulnessSessionRecord#MINDFULNESS_SESSION_TYPE_UNGUIDED}
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime, int mindfulnessSessionType) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@link android.health.connect.datatypes.MindfulnessSessionRecord MindfulnessSessionRecord}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MindfulnessSessionRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity ended
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MindfulnessSessionRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets notes for this activity
 *
 * @param notes Additional notes for the session. Optional field.
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MindfulnessSessionRecord.Builder setNotes(@android.annotation.Nullable java.lang.CharSequence notes) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity started
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MindfulnessSessionRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets a title of this activity
 *
 * @param title Title of the session. Optional field.
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MindfulnessSessionRecord.Builder setTitle(@android.annotation.Nullable java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }
}

}

