/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;

import android.health.connect.MedicalResourceId;

/**
 * A class to capture the user's medical data. This is the class used for all medical resource
 * types.
 *
 * <p>The data representation follows the <a href="https://hl7.org/fhir/">Fast Healthcare
 * Interoperability Resources (FHIR)</a> standard.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MedicalResource implements android.os.Parcelable {

MedicalResource() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the unique {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} ID of where the data comes from.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDataSourceId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the enclosed {@link android.health.connect.datatypes.FhirResource FhirResource} object.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.FhirResource getFhirResource() { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR version being used for {@code mFhirResource}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.FhirVersion getFhirVersion() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ID of this {@link android.health.connect.datatypes.MedicalResource MedicalResource} as {@link android.health.connect.MedicalResourceId MedicalResourceId}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.MedicalResourceId getId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the medical resource type, assigned by the Android Health Platform at insertion time.
 *
 * <p>For a list of supported types, see the {@link android.health.connect.datatypes.MedicalResource MedicalResource} type constants, such as
 * {@link #MEDICAL_RESOURCE_TYPE_VACCINES}. Clients should be aware that this list is non
 * exhaustive and may increase in future releases when additional types will need to be handled.

 * @return Value is {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_CONDITIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_MEDICATIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PREGNANCY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PROCEDURES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VACCINES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VISITS}, or {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VITAL_SIGNS}
 */

public int getType() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.datatypes.MedicalResource> CREATOR;
static { CREATOR = null; }

/** Medical resource type labelling data as allergies or intolerances. */

public static final int MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES = 2; // 0x2

/**
 * Medical resource type labelling data as medical conditions (clinical condition, problem,
 * diagnosis etc).
 */

public static final int MEDICAL_RESOURCE_TYPE_CONDITIONS = 7; // 0x7

/** Medical resource type labelling data as results (Laboratory or pathology). */

public static final int MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS = 6; // 0x6

/** Medical resource type labelling data as medication related. */

public static final int MEDICAL_RESOURCE_TYPE_MEDICATIONS = 9; // 0x9

/**
 * Medical resource type labelling data as related to personal details, including demographic
 * information such as name, date of birth, and contact details such as address or telephone
 * numbers.
 */

public static final int MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS = 10; // 0xa

/**
 * Medical resource type labelling data as related to practitioners. This is information about
 * the doctors, nurses, masseurs, physios, etc who have been involved with the user.
 */

public static final int MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS = 11; // 0xb

/** Medical resource type labelling data as to do with pregnancy. */

public static final int MEDICAL_RESOURCE_TYPE_PREGNANCY = 3; // 0x3

/** Medical resource type labelling data as procedures (actions taken on or for a patient). */

public static final int MEDICAL_RESOURCE_TYPE_PROCEDURES = 8; // 0x8

/** Medical resource type labelling data as social history. */

public static final int MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY = 4; // 0x4

/** Medical resource type labelling data as vaccines. */

public static final int MEDICAL_RESOURCE_TYPE_VACCINES = 1; // 0x1

/**
 * Medical resource type labelling data as related to an encounter with a practitioner. This
 * includes visits to healthcare providers and remote encounters such as telephone and
 * videoconference appointments, and information about the time, location and organization who
 * is being met.
 */

public static final int MEDICAL_RESOURCE_TYPE_VISITS = 12; // 0xc

/** Medical resource type labelling data as vital signs. */

public static final int MEDICAL_RESOURCE_TYPE_VITAL_SIGNS = 5; // 0x5
/** Builder class for {@link android.health.connect.datatypes.MedicalResource MedicalResource}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a clone of the other {@link android.health.connect.datatypes.MedicalResource MedicalResource} instance.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.MedicalResource other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.datatypes.MedicalResource.Builder MedicalResource.Builder}.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.MedicalResource.Builder other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.health.connect.datatypes.MedicalResource.Builder MedicalResource.Builder} instance.
 *
 * @param type The medical resource type.
 * Value is {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_CONDITIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_MEDICATIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PREGNANCY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PROCEDURES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VACCINES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VISITS}, or {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VITAL_SIGNS}
 * @param dataSourceId The unique {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} ID of where the data comes from.
 * This value cannot be {@code null}.
 * @param fhirVersion the FHIR version being used for {@code fhirResource}.
 * This value cannot be {@code null}.
 * @param fhirResource The enclosed {@link android.health.connect.datatypes.FhirResource FhirResource} object.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided medical resource {@code type} is not a
 *     valid supported type, or {@code dataSourceId} is not a valid ID.
 */

public Builder(int type, @android.annotation.NonNull java.lang.String dataSourceId, @android.annotation.NonNull android.health.connect.datatypes.FhirVersion fhirVersion, @android.annotation.NonNull android.health.connect.datatypes.FhirResource fhirResource) { throw new RuntimeException("Stub!"); }

/**
 * Returns a new instance of {@link android.health.connect.datatypes.MedicalResource MedicalResource} with the specified parameters.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalResource build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the unique {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} ID of where the data comes from.
 *
 * @throws java.lang.IllegalArgumentException if the provided {@code dataSourceId} is not a valid ID.
 
 * @param dataSourceId This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalResource.Builder setDataSourceId(@android.annotation.NonNull java.lang.String dataSourceId) { throw new RuntimeException("Stub!"); }

/**
 * Sets the enclosed {@link android.health.connect.datatypes.FhirResource FhirResource} object.
 * @param fhirResource This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalResource.Builder setFhirResource(@android.annotation.NonNull android.health.connect.datatypes.FhirResource fhirResource) { throw new RuntimeException("Stub!"); }

/**
 * Sets the FHIR version being used for {@code fhirResource}.
 * @param fhirVersion This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalResource.Builder setFhirVersion(@android.annotation.NonNull android.health.connect.datatypes.FhirVersion fhirVersion) { throw new RuntimeException("Stub!"); }

/**
 * Sets the medical resource type.
 *
 * @throws java.lang.IllegalArgumentException if the provided medical resource {@code type} is not a
 *     valid supported type.
 
 * @param type Value is {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_CONDITIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_MEDICATIONS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PREGNANCY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_PROCEDURES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VACCINES}, {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VISITS}, or {@link android.health.connect.datatypes.MedicalResource#MEDICAL_RESOURCE_TYPE_VITAL_SIGNS}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalResource.Builder setType(int type) { throw new RuntimeException("Stub!"); }
}

}

