/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/**
 * Captures the data source information of medical data. All {@link android.health.connect.datatypes.MedicalResource MedicalResource}s are associated
 * with a {@code MedicalDataSource}.
 *
 * <p>The medical data is represented using the <a href="https://hl7.org/fhir/">Fast Healthcare
 * Interoperability Resources (FHIR)</a> standard.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MedicalDataSource implements android.os.Parcelable {

MedicalDataSource() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the display name.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDisplayName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR base URI, where data written for this data source came from.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getFhirBaseUri() { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR version of {@link android.health.connect.datatypes.MedicalResource MedicalResource}s from this source.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.FhirVersion getFhirVersion() { throw new RuntimeException("Stub!"); }

/**
 * Returns the unique identifier, assigned by the Android Health Platform at insertion time.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the time {@link android.health.connect.datatypes.MedicalResource MedicalResource}s linked to this data source were last updated, or
 * {@code null} if the data source has no linked resources.
 *
 * <p>This time is based on resources that currently exist in HealthConnect, so does not reflect
 * data deletion.
 */

@android.annotation.Nullable
public java.time.Instant getLastDataUpdateTime() { throw new RuntimeException("Stub!"); }

/**
 * Returns the corresponding package name of the owning app.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Returns a string representation of this {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}. */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.datatypes.MedicalDataSource> CREATOR;
static { CREATOR = null; }
/** Builder class for {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a clone of the other {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} instance.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.MedicalDataSource other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a clone of the other {@link android.health.connect.datatypes.MedicalDataSource.Builder MedicalDataSource.Builder}.
 * @param other This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.MedicalDataSource.Builder other) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.health.connect.datatypes.MedicalDataSource.Builder MedicalDataSource.Builder} instance.
 *
 * @param id The unique identifier of this data source.
 * This value cannot be {@code null}.
 * @param packageName The package name of the owning app.
 * This value cannot be {@code null}.
 * @param fhirBaseUri The FHIR base URI of the data source.
 * This value cannot be {@code null}.
 * @param displayName The display name that describes the data source.
 * This value cannot be {@code null}.
 * @param fhirVersion The FHIR version of {@link android.health.connect.datatypes.MedicalResource MedicalResource}s linked to this source.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String id, @android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull android.net.Uri fhirBaseUri, @android.annotation.NonNull java.lang.String displayName, @android.annotation.NonNull android.health.connect.datatypes.FhirVersion fhirVersion) { throw new RuntimeException("Stub!"); }

/**
 * Returns a new instance of {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} with the specified parameters.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalDataSource build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the display name that describes this data source.
 * @param displayName This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalDataSource.Builder setDisplayName(@android.annotation.NonNull java.lang.String displayName) { throw new RuntimeException("Stub!"); }

/**
 * Sets the FHIR base URI of this data source.
 * @param fhirBaseUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalDataSource.Builder setFhirBaseUri(@android.annotation.NonNull android.net.Uri fhirBaseUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the FHIR version of {@link android.health.connect.datatypes.MedicalResource MedicalResource}s linked to this source.
 * @param fhirVersion This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalDataSource.Builder setFhirVersion(@android.annotation.NonNull android.health.connect.datatypes.FhirVersion fhirVersion) { throw new RuntimeException("Stub!"); }

/**
 * Sets unique identifier of this data source.
 * @param id This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalDataSource.Builder setId(@android.annotation.NonNull java.lang.String id) { throw new RuntimeException("Stub!"); }

/**
 * Sets the time {@link android.health.connect.datatypes.MedicalResource MedicalResource}s linked to this data source were last updated.
 * @param lastDataUpdateTime This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalDataSource.Builder setLastDataUpdateTime(@android.annotation.Nullable java.time.Instant lastDataUpdateTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the package name of the contributing package. Auto-populated by the platform at
 * source creation time.
 
 * @param packageName This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalDataSource.Builder setPackageName(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }
}

}

