/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/** Identifier for exercise types, as returned by {@link android.health.connect.datatypes.ExerciseSegment#getSegmentType() ExerciseSegment.getSegmentType()}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ExerciseSegmentType {

ExerciseSegmentType() { throw new RuntimeException("Stub!"); }

/** Use this type for arm curls. */

public static final int EXERCISE_SEGMENT_TYPE_ARM_CURL = 26; // 0x1a

/** Use this type for back extensions. */

public static final int EXERCISE_SEGMENT_TYPE_BACK_EXTENSION = 27; // 0x1b

/** Use this type for ball slams. */

public static final int EXERCISE_SEGMENT_TYPE_BALL_SLAM = 28; // 0x1c

/** Use this type for barbel shoulder press. */

public static final int EXERCISE_SEGMENT_TYPE_BARBELL_SHOULDER_PRESS = 1; // 0x1

/** Use this type for bench presses. */

public static final int EXERCISE_SEGMENT_TYPE_BENCH_PRESS = 29; // 0x1d

/** Use this type for bench sit up. */

public static final int EXERCISE_SEGMENT_TYPE_BENCH_SIT_UP = 2; // 0x2

/** Use this type for biking. */

public static final int EXERCISE_SEGMENT_TYPE_BIKING = 3; // 0x3

/** Use this type for stationary biking. */

public static final int EXERCISE_SEGMENT_TYPE_BIKING_STATIONARY = 4; // 0x4

/** Use this type for burpees. */

public static final int EXERCISE_SEGMENT_TYPE_BURPEE = 30; // 0x1e

/** Use this type for crunches. */

public static final int EXERCISE_SEGMENT_TYPE_CRUNCH = 31; // 0x1f

/** Use this type for deadlifts. */

public static final int EXERCISE_SEGMENT_TYPE_DEADLIFT = 32; // 0x20

/** Use this type for double arms triceps extensions. */

public static final int EXERCISE_SEGMENT_TYPE_DOUBLE_ARM_TRICEPS_EXTENSION = 33; // 0x21

/** Use this type for left arm dumbbell curl. */

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_CURL_LEFT_ARM = 5; // 0x5

/** Use this type for right arm dumbbell curl. */

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_CURL_RIGHT_ARM = 6; // 0x6

/** Use this type for right arm dumbbell front raise. */

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_FRONT_RAISE = 7; // 0x7

/** Use this type for dumbbell lateral raises. */

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_LATERAL_RAISE = 8; // 0x8

/** Use this type for dumbbells rows. */

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_ROW = 34; // 0x22

/** Use this type for left arm triceps extensions. */

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_TRICEPS_EXTENSION_LEFT_ARM = 9; // 0x9

/** Use this type for right arm triceps extensions. */

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_TRICEPS_EXTENSION_RIGHT_ARM = 10; // 0xa

/** Use this type for two arms triceps extensions. */

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_TRICEPS_EXTENSION_TWO_ARM = 11; // 0xb

/** Use this type for elliptical workout. */

public static final int EXERCISE_SEGMENT_TYPE_ELLIPTICAL = 12; // 0xc

/** Use this type for forward twists. */

public static final int EXERCISE_SEGMENT_TYPE_FORWARD_TWIST = 13; // 0xd

/** Use this type for front raises. */

public static final int EXERCISE_SEGMENT_TYPE_FRONT_RAISE = 35; // 0x23

/** Use this type for high intensity training. */

public static final int EXERCISE_SEGMENT_TYPE_HIGH_INTENSITY_INTERVAL_TRAINING = 62; // 0x3e

/** Use this type for hip thrusts. */

public static final int EXERCISE_SEGMENT_TYPE_HIP_THRUST = 36; // 0x24

/** Use this type for hula-hoops. */

public static final int EXERCISE_SEGMENT_TYPE_HULA_HOOP = 37; // 0x25

/** Use this type for jumping jacks. */

public static final int EXERCISE_SEGMENT_TYPE_JUMPING_JACK = 38; // 0x26

/** Use this type for jump rope. */

public static final int EXERCISE_SEGMENT_TYPE_JUMP_ROPE = 39; // 0x27

/** Use this type for kettlebell swings. */

public static final int EXERCISE_SEGMENT_TYPE_KETTLEBELL_SWING = 40; // 0x28

/** Use this type for lateral raises. */

public static final int EXERCISE_SEGMENT_TYPE_LATERAL_RAISE = 41; // 0x29

/** Use this type for lat pull-downs. */

public static final int EXERCISE_SEGMENT_TYPE_LAT_PULL_DOWN = 42; // 0x2a

/** Use this type for leg curls. */

public static final int EXERCISE_SEGMENT_TYPE_LEG_CURL = 43; // 0x2b

/** Use this type for leg extensions. */

public static final int EXERCISE_SEGMENT_TYPE_LEG_EXTENSION = 44; // 0x2c

/** Use this type for leg presses. */

public static final int EXERCISE_SEGMENT_TYPE_LEG_PRESS = 45; // 0x2d

/** Use this type for leg raises. */

public static final int EXERCISE_SEGMENT_TYPE_LEG_RAISE = 46; // 0x2e

/** Use this type for lunges. */

public static final int EXERCISE_SEGMENT_TYPE_LUNGE = 47; // 0x2f

/** Use this type for mountain climber. */

public static final int EXERCISE_SEGMENT_TYPE_MOUNTAIN_CLIMBER = 48; // 0x30

/** Use this type for other workout. */

public static final int EXERCISE_SEGMENT_TYPE_OTHER_WORKOUT = 64; // 0x40

/** Use this type for the pause. */

public static final int EXERCISE_SEGMENT_TYPE_PAUSE = 67; // 0x43

/** Use this type for pilates. */

public static final int EXERCISE_SEGMENT_TYPE_PILATES = 14; // 0xe

/** Use this type for plank. */

public static final int EXERCISE_SEGMENT_TYPE_PLANK = 49; // 0x31

/** Use this type for pull-ups. */

public static final int EXERCISE_SEGMENT_TYPE_PULL_UP = 50; // 0x32

/** Use this type for punches. */

public static final int EXERCISE_SEGMENT_TYPE_PUNCH = 51; // 0x33

/** Use this type for the rest. */

public static final int EXERCISE_SEGMENT_TYPE_REST = 66; // 0x42

/** Use this type for rowing machine workout. */

public static final int EXERCISE_SEGMENT_TYPE_ROWING_MACHINE = 15; // 0xf

/** Use this type for running. */

public static final int EXERCISE_SEGMENT_TYPE_RUNNING = 16; // 0x10

/** Use this type for treadmill running. */

public static final int EXERCISE_SEGMENT_TYPE_RUNNING_TREADMILL = 17; // 0x11

/** Use this type for shoulder press. */

public static final int EXERCISE_SEGMENT_TYPE_SHOULDER_PRESS = 52; // 0x34

/** Use this type for single arm triceps extension. */

public static final int EXERCISE_SEGMENT_TYPE_SINGLE_ARM_TRICEPS_EXTENSION = 53; // 0x35

/** Use this type for sit-ups. */

public static final int EXERCISE_SEGMENT_TYPE_SIT_UP = 54; // 0x36

/** Use this type for squats. */

public static final int EXERCISE_SEGMENT_TYPE_SQUAT = 55; // 0x37

/** Use this type for stair climbing. */

public static final int EXERCISE_SEGMENT_TYPE_STAIR_CLIMBING = 18; // 0x12

/** Use this type for stair climbing machine. */

public static final int EXERCISE_SEGMENT_TYPE_STAIR_CLIMBING_MACHINE = 19; // 0x13

/** Use this type for stretching. */

public static final int EXERCISE_SEGMENT_TYPE_STRETCHING = 20; // 0x14

/** Use this type for backstroke swimming. */

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_BACKSTROKE = 57; // 0x39

/** Use this type for breaststroke swimming. */

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_BREASTSTROKE = 58; // 0x3a

/** Use this type for butterfly swimming. */

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_BUTTERFLY = 59; // 0x3b

/** Use this type for freestyle swimming. */

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_FREESTYLE = 56; // 0x38

/** Use this type for mixed swimming. */

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_MIXED = 60; // 0x3c

/** Use this type for swimming in open water. */

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_OPEN_WATER = 21; // 0x15

/** Use this type if other swimming styles are not suitable. */

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_OTHER = 61; // 0x3d

/** Use this type for swimming in the pool. */

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_POOL = 22; // 0x16

/** Use this type if the type of the exercise segment is not known. */

public static final int EXERCISE_SEGMENT_TYPE_UNKNOWN = 0; // 0x0

/** Use this type for upper twists. */

public static final int EXERCISE_SEGMENT_TYPE_UPPER_TWIST = 23; // 0x17

/** Use this type for walking. */

public static final int EXERCISE_SEGMENT_TYPE_WALKING = 24; // 0x18

/** Use this type for weightlifting. */

public static final int EXERCISE_SEGMENT_TYPE_WEIGHTLIFTING = 63; // 0x3f

/** Use this type for wheelchair. */

public static final int EXERCISE_SEGMENT_TYPE_WHEELCHAIR = 25; // 0x19

/** Use this type for yoga. */

public static final int EXERCISE_SEGMENT_TYPE_YOGA = 65; // 0x41
}

