/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/** Route of the exercise session. Contains sequence of location points with timestamps. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ExerciseRoute implements android.os.Parcelable {

/**
 * Creates {@link android.health.connect.datatypes.ExerciseRoute ExerciseRoute} instance
 *
 * @param routeLocations list of locations with timestamps that make up the route

 * This value cannot be {@code null}.
 */

public ExerciseRoute(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.ExerciseRoute.Location> routeLocations) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.ExerciseRoute.Location> getRouteLocations() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.datatypes.ExerciseRoute> CREATOR;
static { CREATOR = null; }
/** Point in the time and space. Used in {@link android.health.connect.datatypes.ExerciseRoute ExerciseRoute}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Location implements android.os.Parcelable {

Location() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns altitude of this location time point. Returns null if no altitude was specified.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Length getAltitude() { throw new RuntimeException("Stub!"); }

/**
 * Returns horizontal accuracy of this location time point. Returns null if no horizontal
 * accuracy was specified.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Length getHorizontalAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Returns latitude of this location
 * @return Value is between -90.0 and 90.0 inclusive
 */

public double getLatitude() { throw new RuntimeException("Stub!"); }

/**
 * Returns longitude of this location
 * @return Value is between -180.0 and 180.0 inclusive
 */

public double getLongitude() { throw new RuntimeException("Stub!"); }

/**
 * Returns time when this location has been recorded
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getTime() { throw new RuntimeException("Stub!"); }

/**
 * Returns vertical accuracy of this location time point. Returns null if no vertical
 * accuracy was specified.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Length getVerticalAccuracy() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.datatypes.ExerciseRoute.Location> CREATOR;
static { CREATOR = null; }
/** Builder class for {@link android.health.connect.datatypes.ExerciseRoute.Location Location} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Sets time, longitude and latitude to the point.
 * @param time This value cannot be {@code null}.
 
 * @param latitude Value is between -90.0 and 90.0 inclusive

 * @param longitude Value is between -180.0 and 180.0 inclusive
 */

public Builder(@android.annotation.NonNull java.time.Instant time, double latitude, double longitude) { throw new RuntimeException("Stub!"); }

/**
 * Builds {@link android.health.connect.datatypes.ExerciseRoute.Location Location}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseRoute.Location build() { throw new RuntimeException("Stub!"); }

/**
 * Sets altitude to the point.
 * @param altitude This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseRoute.Location.Builder setAltitude(@android.annotation.NonNull android.health.connect.datatypes.units.Length altitude) { throw new RuntimeException("Stub!"); }

/**
 * Sets horizontal accuracy to the point.
 * @param horizontalAccuracy This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseRoute.Location.Builder setHorizontalAccuracy(@android.annotation.NonNull android.health.connect.datatypes.units.Length horizontalAccuracy) { throw new RuntimeException("Stub!"); }

/**
 * Sets vertical accuracy to the point.
 * @param verticalAccuracy This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseRoute.Location.Builder setVerticalAccuracy(@android.annotation.NonNull android.health.connect.datatypes.units.Length verticalAccuracy) { throw new RuntimeException("Stub!"); }
}

}

}

