/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;

import android.health.connect.datatypes.units.Length;

/**
 * Captures the time of a lap within exercise session. Part of {@link android.health.connect.datatypes.ExerciseSessionRecord ExerciseSessionRecord}.
 *
 * <p>Each record contains the start and end time and optional {@link android.health.connect.datatypes.units.Length Length} of the lap (e.g. pool
 * length while swimming or a track lap while running). There may or may not be direct correlation
 * with {@link android.health.connect.datatypes.ExerciseSegment ExerciseSegment} start and end times, e.g. {@link android.health.connect.datatypes.ExerciseSessionRecord ExerciseSessionRecord} of type
 * running without any segments can be divided as laps of different lengths.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ExerciseLap {

ExerciseLap() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getEndTime() { throw new RuntimeException("Stub!"); }

/**
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Length getLength() { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getStartTime() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.datatypes.ExerciseLap ExerciseLap} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param startTime This value cannot be {@code null}.

 * @param endTime This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime) { throw new RuntimeException("Stub!"); }

/**
 * Builds {@link android.health.connect.datatypes.ExerciseLap ExerciseLap} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseLap build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the length of this lap
 *
 * @param length Length of the lap, in {@link android.health.connect.datatypes.units.Length Length} unit. Optional field. Valid range:
 *     0-1000000 meters.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseLap.Builder setLength(@android.annotation.NonNull android.health.connect.datatypes.units.Length length) { throw new RuntimeException("Stub!"); }
}

}

