/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import android.health.connect.datatypes.units.Temperature;

/**
 * Captures the body temperature of a user when at rest (for example, immediately after waking up).
 * Can be used for checking the fertility window. Each data point represents a single instantaneous
 * body temperature measurement.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BasalBodyTemperatureRecord extends android.health.connect.datatypes.InstantRecord {

BasalBodyTemperatureRecord() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return measurementLocation

 * Value is {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_UNKNOWN}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_ARMPIT}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_FINGER}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_FOREHEAD}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_MOUTH}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_RECTUM}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_TEMPORAL_ARTERY}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_TOE}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_EAR}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_WRIST}, or {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_VAGINA}
 */

public int getMeasurementLocation() { throw new RuntimeException("Stub!"); }

/**
 * @return temperature in {@link android.health.connect.datatypes.units.Temperature Temperature} unit.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Temperature getTemperature() { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.datatypes.BasalBodyTemperatureRecord BasalBodyTemperatureRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param time Start time of this activity
 * This value cannot be {@code null}.
 * @param measurementLocation Where on the user's basal body the temperature measurement was
 *     taken from. Optional field. Allowed values: {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation BodyTemperatureMeasurementLocation}.
 * Value is {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_UNKNOWN}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_ARMPIT}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_FINGER}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_FOREHEAD}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_MOUTH}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_RECTUM}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_TEMPORAL_ARTERY}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_TOE}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_EAR}, {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_WRIST}, or {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation#MEASUREMENT_LOCATION_VAGINA}
 * @param temperature Temperature in {@link android.health.connect.datatypes.units.Temperature Temperature} unit. Required field. Valid range:
 *     0-100 Celsius degrees.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, int measurementLocation, @android.annotation.NonNull android.health.connect.datatypes.units.Temperature temperature) { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.BasalBodyTemperatureRecord BasalBodyTemperatureRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BasalBodyTemperatureRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BasalBodyTemperatureRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity happened
 * @param zoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BasalBodyTemperatureRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }
}

}

